/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fit.Counts;
import fitnesse.components.ContentBuffer;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlPageFactory;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.responders.run.SuiteHtmlFormatter;
import fitnesse.runner.PageResult;
import fitnesse.runner.ResultFormatter;
import java.io.InputStream;

public class HtmlResultFormatter
implements ResultFormatter {
    private ContentBuffer buffer;
    private boolean closed = false;
    private SuiteHtmlFormatter suiteFormatter;
    private String host;
    private String rootPath;
    private HtmlPage page;
    public static final String scriptContent = "\nfunction localizeInPageLinks()\n{\n\tvar base = document.getElementsByTagName('base')[0].href;\n\tvar inPageBase = base + \"#\";\n\tvar baseLength = inPageBase.length\n\tvar aTags = document.getElementsByTagName('a');\n\tfor(var i=0; i < aTags.length; i++)\n\t{\n\t\tvar tag = aTags[i];\n\t\tif(tag.href && tag.href.substring(0, baseLength) == inPageBase)\n\t\t\ttag.href = location.href + '#' + tag.href.substring(baseLength);\n\t}\n}\n";

    public HtmlResultFormatter(HtmlPageFactory htmlPageFactory, String string, String string2) throws Exception {
        this.host = string;
        this.rootPath = string2;
        this.buffer = new ContentBuffer(".html");
        this.createPage(htmlPageFactory, string2);
        this.suiteFormatter = new SuiteHtmlFormatter(this.page);
        this.buffer.append(this.suiteFormatter.head());
    }

    private void createPage(HtmlPageFactory htmlPageFactory, String string) throws Exception {
        this.page = htmlPageFactory.newPage();
        this.page.head.use(this.makeBaseTag());
        this.page.head.add(this.makeContentTypeMetaTag());
        this.page.title.use(string);
        this.page.head.add(this.page.title);
        this.page.head.add(this.page.makeCssLink("/files/css/fitnesse_print.css", "screen"));
        HtmlTag htmlTag = new HtmlTag("script", scriptContent);
        htmlTag.addAttribute("language", "javascript");
        this.page.head.add(htmlTag);
        this.page.body.addAttribute("onload", "localizeInPageLinks()");
        this.page.header.use(HtmlUtil.makeBreadCrumbsWithPageType(string, "Command Line Test Results"));
    }

    private HtmlTag makeContentTypeMetaTag() {
        HtmlTag htmlTag = new HtmlTag("meta");
        htmlTag.addAttribute("http-equiv", "Content-Type");
        htmlTag.addAttribute("content", "text/html; charset=utf-8");
        return htmlTag;
    }

    private HtmlTag makeBaseTag() {
        HtmlTag htmlTag = new HtmlTag("base");
        StringBuffer stringBuffer = new StringBuffer("http://");
        stringBuffer.append(this.host);
        stringBuffer.append("/");
        htmlTag.addAttribute("href", stringBuffer.toString());
        return htmlTag;
    }

    public void acceptResult(PageResult pageResult) throws Exception {
        String string = pageResult.title();
        this.suiteFormatter.startOutputForNewTest(string, this.rootPath + "." + string);
        this.suiteFormatter.acceptOutput(pageResult.content());
        String string2 = this.suiteFormatter.acceptResults(string, pageResult.counts());
        this.buffer.append(string2);
    }

    public void acceptFinalCount(Counts counts) throws Exception {
        this.buffer.append(this.suiteFormatter.testSummary(counts));
        this.buffer.append(this.suiteFormatter.testOutput());
    }

    private void close() throws Exception {
        if (!this.closed) {
            this.buffer.append(this.suiteFormatter.tail());
            this.closed = true;
        }
    }

    public int getByteCount() throws Exception {
        this.close();
        return this.buffer.getSize();
    }

    public InputStream getResultStream() throws Exception {
        this.close();
        return this.buffer.getInputStream();
    }
}

