/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fitnesse.components.CommandLine;
import fitnesse.http.RequestBuilder;
import fitnesse.http.ResponseParser;
import fitnesse.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FormattingOption {
    public String format;
    public boolean usingStdout = false;
    public OutputStream output;
    public String host;
    public int port;
    public String rootPath;
    private int status;
    public String filename;
    private String resultFilename;

    public static void main(String[] stringArray) throws Exception {
        FormattingOption formattingOption = new FormattingOption();
        formattingOption.args(stringArray);
        File file = new File(formattingOption.resultFilename);
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = (int)file.length();
        formattingOption.process(fileInputStream, n);
    }

    private FormattingOption() {
    }

    private void args(String[] stringArray) throws Exception {
        CommandLine commandLine = new CommandLine("resultFilename format outputFilename host port rootPath");
        if (!commandLine.parse(stringArray)) {
            this.usage();
        }
        this.resultFilename = commandLine.getArgument("resultFilename");
        this.format = commandLine.getArgument("format");
        this.filename = commandLine.getArgument("outputFilename");
        this.host = commandLine.getArgument("host");
        this.port = Integer.parseInt(commandLine.getArgument("port"));
        this.rootPath = commandLine.getArgument("rootPath");
        this.setOutput(System.out);
    }

    private void usage() {
        System.out.println("java fitnesse.runner.FormattingOption resultFilename format outputFilename host port rootPath");
        System.out.println("\tresultFilename:\tthe name of the file containing test results");
        System.out.println("\tformat:        \traw|html|xml|...");
        System.out.println("\toutputfilename:\tstdout|a filename where the formatted results are to be stored");
        System.out.println("\thost:          \tthe domain name of the hosting FitNesse server");
        System.out.println("\tport:          \tthe port on which the hosting FitNesse server is running");
        System.out.println("\trootPath:      \tname of the test page or suite page");
        System.exit(-1);
    }

    public FormattingOption(String string, String string2, OutputStream outputStream, String string3, int n, String string4) throws Exception {
        this.format = string;
        this.filename = string2;
        this.setOutput(outputStream);
        this.host = string3;
        this.port = n;
        this.rootPath = string4;
    }

    private void setOutput(OutputStream outputStream) throws FileNotFoundException {
        if ("stdout".equals(this.filename)) {
            this.output = outputStream;
            this.usingStdout = true;
        } else {
            this.output = new FileOutputStream(this.filename);
        }
    }

    public void process(InputStream inputStream, int n) throws Exception {
        if ("raw".equals(this.format)) {
            FileUtil.copyBytes(inputStream, this.output);
        } else {
            RequestBuilder requestBuilder = this.buildRequest(inputStream, n);
            ResponseParser responseParser = ResponseParser.performHttpRequest(this.host, this.port, requestBuilder);
            this.status = responseParser.getStatus();
            this.output.write(responseParser.getBody().getBytes("UTF-8"));
        }
        if (!this.usingStdout) {
            this.output.close();
        }
    }

    public boolean wasSuccessful() {
        return this.status == 200;
    }

    public RequestBuilder buildRequest(InputStream inputStream, int n) throws Exception {
        RequestBuilder requestBuilder = new RequestBuilder("/" + this.rootPath);
        requestBuilder.setMethod("POST");
        requestBuilder.setHostAndPort(this.host, this.port);
        requestBuilder.addInput("responder", "format");
        requestBuilder.addInput("format", this.format);
        requestBuilder.addInputAsPart("results", inputStream, n, "text/plain");
        return requestBuilder;
    }
}

