/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fit.Counts;
import fitnesse.components.ContentBuffer;
import fitnesse.components.FitProtocol;
import fitnesse.runner.PageResult;
import fitnesse.runner.ResultFormatter;
import fitnesse.runner.ResultHandler;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CachingResultFormatter
implements ResultFormatter {
    private ContentBuffer buffer;
    public List subHandlers = new LinkedList();

    public CachingResultFormatter() throws Exception {
        this.buffer = new ContentBuffer(".results");
    }

    public void acceptResult(PageResult pageResult) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FitProtocol.writeData(pageResult.toString() + "\n", (OutputStream)byteArrayOutputStream);
        this.buffer.append(byteArrayOutputStream.toByteArray());
        Iterator iterator = this.subHandlers.iterator();
        while (iterator.hasNext()) {
            ((ResultHandler)iterator.next()).acceptResult(pageResult);
        }
    }

    public void acceptFinalCount(Counts counts) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FitProtocol.writeCounts(counts, byteArrayOutputStream);
        this.buffer.append(byteArrayOutputStream.toByteArray());
        Iterator iterator = this.subHandlers.iterator();
        while (iterator.hasNext()) {
            ((ResultHandler)iterator.next()).acceptFinalCount(counts);
        }
    }

    public int getByteCount() throws Exception {
        return this.buffer.getSize();
    }

    public InputStream getResultStream() throws Exception {
        return this.buffer.getNonDeleteingInputStream();
    }

    public void cleanUp() throws Exception {
        this.buffer.delete();
    }

    public void addHandler(ResultHandler resultHandler) {
        this.subHandlers.add(resultHandler);
    }
}

