/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.versions;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.RawHtml;
import fitnesse.html.TagGroup;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class VersionSelectionResponder
implements Responder {
    private WikiPage page;
    private List versions;
    private List ageStrings;
    private PageData pageData;
    private String resource;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        SimpleResponse simpleResponse = new SimpleResponse();
        this.resource = request.getResource();
        WikiPagePath wikiPagePath = PathParser.parse(this.resource);
        this.page = fitNesseContext.root.getPageCrawler().getPage(fitNesseContext.root, wikiPagePath);
        if (this.page == null) {
            return new NotFoundResponder().makeResponse(fitNesseContext, request);
        }
        this.pageData = this.page.getData();
        this.versions = VersionSelectionResponder.getVersionsList(this.pageData);
        this.ageStrings = new ArrayList();
        Date date = new GregorianCalendar().getTime();
        for (VersionInfo versionInfo : this.versions) {
            this.ageStrings.add(VersionSelectionResponder.howLongAgoString(date, versionInfo.getCreationTime()));
        }
        simpleResponse.setContent(this.makeHtml(fitNesseContext));
        return simpleResponse;
    }

    public String makeHtml(FitNesseContext fitNesseContext) throws Exception {
        HtmlPage htmlPage = fitNesseContext.htmlPageFactory.newPage();
        htmlPage.title.use("Version Selection: " + this.resource);
        htmlPage.header.use(HtmlUtil.makeBreadCrumbsWithPageType(this.resource, "Version Selection"));
        htmlPage.main.use(this.makeRightColumn());
        return htmlPage.html();
    }

    public HtmlTag makeRightColumn() throws Exception {
        TagGroup tagGroup = new TagGroup();
        tagGroup.add(new HtmlTag("h3", "Select a version."));
        HtmlTag htmlTag = new HtmlTag("form");
        String string = PathParser.render(this.page.getPageCrawler().getFullPath(this.page));
        htmlTag.addAttribute("action", string);
        htmlTag.addAttribute("method", "get");
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "responder", "viewVersion"));
        HtmlTag htmlTag2 = new HtmlTag("table");
        htmlTag2.addAttribute("cellspacing", "0");
        htmlTag2.add(this.makeRow("th", new RawHtml("&nbsp;"), "Name", "Author", "Age"));
        for (int i = 0; i < this.versions.size(); ++i) {
            htmlTag2.add(this.makeVersionRow(i));
        }
        htmlTag.add(htmlTag2);
        htmlTag.add(HtmlUtil.makeInputTag("submit", "save", "View Version"));
        tagGroup.add(htmlTag);
        return tagGroup;
    }

    private HtmlTag makeVersionRow(int n) {
        VersionInfo versionInfo = (VersionInfo)this.versions.get(n);
        HtmlTag htmlTag = HtmlUtil.makeInputTag("radio", "version", versionInfo.getName());
        return this.makeRow("td", htmlTag, versionInfo.getName(), versionInfo.getAuthor(), this.ageStrings.get(n).toString());
    }

    private HtmlTag makeRow(String string, HtmlElement htmlElement, String string2, String string3, String string4) {
        HtmlTag htmlTag = new HtmlTag("tr");
        htmlTag.add(new HtmlTag(string, htmlElement));
        htmlTag.add(new HtmlTag(string, string2));
        htmlTag.add(new HtmlTag(string, string3));
        htmlTag.add(new HtmlTag(string, string4));
        return htmlTag;
    }

    public static List getVersionsList(PageData pageData) {
        ArrayList arrayList = new ArrayList(pageData.getVersions());
        Collections.sort(arrayList);
        Collections.reverse(arrayList);
        return arrayList;
    }

    public static String howLongAgoString(Date date, Date date2) {
        long l = Math.abs(date.getTime() - date2.getTime()) / 1000L;
        if (l < 60L) {
            return VersionSelectionResponder.pluralize(l, "second");
        }
        if (l < 3600L) {
            return VersionSelectionResponder.pluralize(l / 60L, "minute");
        }
        if (l < 86400L) {
            return VersionSelectionResponder.pluralize(l / 3600L, "hour");
        }
        if (l < 31536000L) {
            return VersionSelectionResponder.pluralize(l / 86400L, "day");
        }
        return VersionSelectionResponder.pluralize(l / 31536000L, "year");
    }

    private static String pluralize(long l, String string) {
        String string2 = l + " " + string;
        if (l > 1L) {
            string2 = string2 + "s";
        }
        return string2;
    }
}

