/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.versions;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.SecureResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public class VersionResponder
implements SecureResponder {
    private WikiPage page;
    private String version;
    private String resource;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        this.resource = request.getResource();
        this.version = (String)request.getInput("version");
        PageCrawler pageCrawler = fitNesseContext.root.getPageCrawler();
        WikiPagePath wikiPagePath = PathParser.parse(this.resource);
        this.page = pageCrawler.getPage(fitNesseContext.root, wikiPagePath);
        if (this.page == null) {
            return new NotFoundResponder().makeResponse(fitNesseContext, request);
        }
        PageData pageData = this.page.getDataVersion(this.version);
        String string = PathParser.render(pageCrawler.getFullPath(this.page));
        HtmlPage htmlPage = this.makeHtml(string, pageData, fitNesseContext);
        SimpleResponse simpleResponse = new SimpleResponse();
        simpleResponse.setContent(htmlPage.html());
        return simpleResponse;
    }

    private HtmlPage makeHtml(String string, PageData pageData, FitNesseContext fitNesseContext) throws Exception {
        HtmlPage htmlPage = fitNesseContext.htmlPageFactory.newPage();
        htmlPage.title.use("Version " + this.version + ": " + string);
        htmlPage.header.use(HtmlUtil.makeBreadCrumbsWithPageType(this.resource, "Version " + this.version));
        htmlPage.actions.use(HtmlUtil.makeActionLink(string, "Rollback", "responder=rollback&version=" + this.version, "", false));
        htmlPage.main.use(HtmlUtil.makeNormalWikiPageContent(pageData));
        return htmlPage;
    }

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

