/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.search;

import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.components.SearchObserver;
import fitnesse.html.ChunkedResultsListingUtil;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.responders.ChunkingResponder;
import fitnesse.responders.SecureResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;

public abstract class ResultResponder
extends ChunkingResponder
implements SearchObserver,
SecureResponder {
    private int hits = 0;
    private int nextRow = 0;

    protected PageCrawler getPageCrawler() {
        return this.root.getPageCrawler();
    }

    protected void doSending() throws Exception {
        HtmlPage htmlPage = this.context.htmlPageFactory.newPage();
        String string = this.getRenderedPath();
        htmlPage.title.use(this.getTitle() + ": " + string);
        htmlPage.header.use(HtmlUtil.makeBreadCrumbsWithPageType(string, this.getTitle()));
        htmlPage.main.use("<!--BREAKPOINT-->");
        htmlPage.divide();
        this.response.add(htmlPage.preDivision);
        this.response.add(this.buildClientSideSortScriptTag().html());
        this.response.add(this.buildFeedbackDiv().html());
        this.response.add(this.getTableOpen());
        this.response.add(this.buildHeaderRow().html());
        this.response.add(this.getTbodyOpen());
        this.startSearching();
        this.response.add(this.getTbodyClose());
        this.response.add(this.getTableClose());
        this.response.add(this.buildTableSorterScript().html());
        this.response.add(this.buildFeedbackModificationScript().html());
        this.response.add(htmlPage.postDivision);
        this.response.closeAll();
    }

    private String getTbodyClose() {
        return "</tbody>";
    }

    private String getTbodyOpen() {
        return "<tbody>";
    }

    private HtmlTag buildClientSideSortScriptTag() {
        HtmlTag htmlTag = new HtmlTag("script");
        htmlTag.addAttribute("src", "/files/javascript/clientSideSort.js");
        htmlTag.add(" ");
        return htmlTag;
    }

    private String getTableClose() {
        return ChunkedResultsListingUtil.getTableCloseHtml();
    }

    private String getTableOpen() {
        return ChunkedResultsListingUtil.getTableOpenHtml("searchResultsTable");
    }

    private HtmlTag buildFeedbackModificationScript() throws Exception {
        HtmlTag htmlTag = new HtmlTag("script");
        htmlTag.addAttribute("language", "javascript");
        htmlTag.add("document.getElementById(\"feedback\").innerHTML = '" + this.getPageFooterInfo(this.hits) + "'");
        return htmlTag;
    }

    private HtmlTag buildTableSorterScript() throws Exception {
        HtmlTag htmlTag = new HtmlTag("script");
        htmlTag.addAttribute("language", "javascript");
        htmlTag.add("tableSorter = new TableSorter('searchResultsTable', new DateParser(" + ResultResponder.getDateFormatJavascriptRegex() + ",8,2,3,4,5,6));");
        return htmlTag;
    }

    public static String getDateFormatJavascriptRegex() {
        return "/^(\\w+) (jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec) (\\d+) (\\d+).(\\d+).(\\d+) (\\w+) (\\d+)$/";
    }

    private HtmlTag buildHeaderRow() {
        HtmlTag htmlTag = new HtmlTag("thead");
        HtmlTag htmlTag2 = new HtmlTag("tr");
        htmlTag2.add(this.buildPageColumnHeader());
        htmlTag2.add(this.buildLastModifiedColumnHeader());
        htmlTag.add(htmlTag2);
        return htmlTag;
    }

    private HtmlTag buildLastModifiedColumnHeader() {
        HtmlTag htmlTag = new HtmlTag("td", this.buildSortLink("LastModified", "1, 'date'"));
        htmlTag.addAttribute("class", "resultsHeader");
        return htmlTag;
    }

    private HtmlTag buildPageColumnHeader() {
        HtmlTag htmlTag = new HtmlTag("td", this.buildSortLink("Page", "0"));
        htmlTag.addAttribute("class", "resultsHeader");
        return htmlTag;
    }

    private HtmlTag buildSortLink(String string, String string2) {
        HtmlTag htmlTag = new HtmlTag("a");
        htmlTag.addAttribute("href", "javascript:void(tableSorter.sort(" + string2 + "));");
        htmlTag.add(string);
        return htmlTag;
    }

    private HtmlTag buildFeedbackDiv() {
        HtmlTag htmlTag = new HtmlTag("div", "Searching...");
        htmlTag.addAttribute("id", "feedback");
        return htmlTag;
    }

    public void hit(WikiPage wikiPage) throws Exception {
        ++this.hits;
        String string = PathParser.render(this.getPageCrawler().getFullPath(wikiPage));
        HtmlTag htmlTag = new HtmlTag("tr");
        htmlTag.addAttribute("class", "resultsRow" + this.getRow());
        HtmlTag htmlTag2 = new HtmlTag("a", string);
        htmlTag2.addAttribute("href", string);
        htmlTag.add(new HtmlTag("td", htmlTag2));
        htmlTag.add(new HtmlTag("td", "" + wikiPage.getData().getProperties().getLastModificationTime()));
        this.response.add(htmlTag.html());
    }

    private int getRow() {
        return this.nextRow++ % 2 + 1;
    }

    protected abstract String getTitle() throws Exception;

    protected abstract String getPageFooterInfo(int var1) throws Exception;

    protected abstract void startSearching() throws Exception;

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

