/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fit.Counts;
import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.components.FitProtocol;
import fitnesse.http.InputStreamResponse;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.runner.HtmlResultFormatter;
import fitnesse.runner.MockResultFormatter;
import fitnesse.runner.PageResult;
import fitnesse.runner.ResultFormatter;
import fitnesse.runner.XmlResultFormatter;
import fitnesse.util.StreamReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class TestResultFormattingResponder
implements Responder {
    public ResultFormatter formatter = new MockResultFormatter();
    public Counts finalCounts;
    private FitNesseContext context;
    private String baseUrl;
    private String rootPath;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        this.init(fitNesseContext, request);
        String string = (String)request.getInput("results");
        byte[] byArray = string.getBytes("UTF-8");
        this.processResults(new ByteArrayInputStream(byArray));
        InputStreamResponse inputStreamResponse = new InputStreamResponse();
        inputStreamResponse.setBody(this.formatter.getResultStream(), this.formatter.getByteCount());
        return inputStreamResponse;
    }

    public void init(FitNesseContext fitNesseContext, Request request) throws Exception {
        this.context = fitNesseContext;
        this.baseUrl = (String)request.getHeader("Host");
        this.rootPath = request.getResource();
        this.formatter = this.makeFormatter(request);
    }

    public void processResults(InputStream inputStream) throws Exception {
        StreamReader streamReader = new StreamReader(inputStream);
        boolean bl = true;
        while (bl) {
            int n = FitProtocol.readSize(streamReader);
            if (n != 0) {
                String string = streamReader.read(n);
                PageResult pageResult = PageResult.parse(string);
                this.formatter.acceptResult(pageResult);
                continue;
            }
            bl = false;
        }
        this.formatter.acceptFinalCount(FitProtocol.readCounts(streamReader));
    }

    public ResultFormatter makeFormatter(Request request) throws Exception {
        String string = (String)request.getInput("format");
        if (string != null) {
            if ("html".equals(string)) {
                return new HtmlResultFormatter(this.context.htmlPageFactory, this.baseUrl, this.rootPath);
            }
            if ("xml".equals(string)) {
                return new XmlResultFormatter(this.baseUrl, this.rootPath);
            }
        }
        return new MockResultFormatter();
    }
}

