/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fit.Counts;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureTestOperation;
import fitnesse.components.ClassPathBuilder;
import fitnesse.components.CommandRunningFitClient;
import fitnesse.components.FitClientListener;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlUtil;
import fitnesse.html.TagGroup;
import fitnesse.http.Request;
import fitnesse.responders.ChunkingResponder;
import fitnesse.responders.SecureResponder;
import fitnesse.responders.WikiImportProperty;
import fitnesse.responders.run.ExecutionLog;
import fitnesse.responders.run.TestEventListener;
import fitnesse.responders.run.TestHtmlFormatter;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VirtualEnabledPageCrawler;
import fitnesse.wiki.WikiPagePath;
import java.util.LinkedList;

public class TestResponder
extends ChunkingResponder
implements FitClientListener,
SecureResponder {
    protected static final String emptyPageContent = "OH NO! This page is empty!";
    public static final String DEFAULT_COMMAND_PATTERN = "java -cp %p %m";
    protected static final int htmlDepth = 2;
    private static LinkedList<TestEventListener> eventListeners = new LinkedList();
    protected HtmlPage html;
    protected CommandRunningFitClient client;
    protected String command;
    protected ExecutionLog log;
    protected PageData data;
    private boolean closed = false;
    private Counts assertionCounts = new Counts();
    protected TestHtmlFormatter formatter;
    protected String classPath;
    private String testableHtml;

    protected void doSending() throws Exception {
        this.data = this.page.getData();
        this.startHtml();
        this.sendPreTestNotification();
        this.prepareForExecution();
        this.startFitClient(this.classPath);
        if (this.client.isSuccessfullyStarted()) {
            this.performExecution();
        }
        this.finishSending();
    }

    private void sendPreTestNotification() throws Exception {
        for (TestEventListener testEventListener : eventListeners) {
            testEventListener.notifyPreTest(this, this.data);
        }
    }

    protected void finishSending() throws Exception {
        this.completeResponse();
    }

    protected void performExecution() throws Exception {
        this.client.send(this.testableHtml);
        this.client.done();
        this.client.join();
    }

    protected void prepareForExecution() throws Exception {
        this.addToResponse(HtmlUtil.getHtmlOfInheritedPage("PageHeader", this.page));
        this.testableHtml = HtmlUtil.testableHtml(this.data);
        if (this.testableHtml.length() == 0) {
            this.testableHtml = this.handleBlankHtml();
        }
        this.classPath = new ClassPathBuilder().getClasspath(this.page);
    }

    protected void startHtml() throws Exception {
        this.buildHtml();
        this.addToResponse(this.formatter.head());
    }

    protected void startFitClient(String string) throws Exception {
        this.command = this.buildCommand(this.data, this.getClassName(this.data, this.request), string);
        this.client = new CommandRunningFitClient(this, this.command, this.context.port, this.context.socketDealer);
        this.log = new ExecutionLog(this.page, this.client.commandRunner);
        this.client.start();
    }

    protected PageCrawler getPageCrawler() {
        PageCrawler pageCrawler = this.root.getPageCrawler();
        pageCrawler.setDeadEndStrategy(new VirtualEnabledPageCrawler());
        return pageCrawler;
    }

    public void acceptResults(Counts counts) throws Exception {
        this.assertionCounts.tally(counts);
    }

    public synchronized void exceptionOccurred(Exception exception) {
        try {
            this.log.addException(exception);
            this.log.addReason("Test execution aborted abnormally with error code " + this.client.commandRunner.getExitCode());
            this.completeResponse();
            this.client.kill();
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
        }
    }

    protected synchronized void completeResponse() throws Exception {
        if (!this.closed) {
            this.closed = true;
            this.log.publish();
            this.addLogAndClose();
        }
    }

    protected final void addLogAndClose() throws Exception {
        this.addLog();
        this.close();
    }

    protected void close() throws Exception {
        this.response.add(HtmlUtil.getHtmlOfInheritedPage("PageFooter", this.page));
        this.response.add(this.formatter.tail());
        this.response.closeChunks();
        this.response.addTrailingHeader("Exit-Code", String.valueOf(this.client.commandRunner.getExitCode()));
        this.response.closeTrailer();
        this.response.close();
    }

    protected void addLog() throws Exception {
        this.response.add(this.formatter.testSummary(this.assertionCounts));
        this.response.add(this.formatter.executionStatus(this.log));
    }

    public void addToResponse(String string) throws Exception {
        if (!this.closed) {
            this.response.add(string);
        }
    }

    public void acceptOutput(String string) throws Exception {
        this.response.add(string);
    }

    private String handleBlankHtml() throws Exception {
        this.response.add(this.formatter.messageForBlankHtml());
        return emptyPageContent;
    }

    protected void buildHtml() throws Exception {
        PageCrawler pageCrawler = this.page.getPageCrawler();
        WikiPagePath wikiPagePath = pageCrawler.getFullPath(this.page);
        String string = PathParser.render(wikiPagePath);
        this.html = this.context.htmlPageFactory.newPage();
        this.html.title.use(this.pageType() + ": " + string);
        this.html.header.use(HtmlUtil.makeBreadCrumbsWithPageType(string, this.pageType()));
        this.html.actions.use(HtmlUtil.makeActions(this.data));
        WikiImportProperty.handleImportProperties(this.html, this.page, this.data);
        this.makeFormatter();
    }

    protected void makeFormatter() throws Exception {
        this.formatter = new TestHtmlFormatter(this.html);
    }

    protected String pageType() {
        return "Test Results";
    }

    protected String title() throws Exception {
        WikiPagePath wikiPagePath = this.getPageCrawler().getFullPath(this.page);
        TagGroup tagGroup = new TagGroup();
        tagGroup.add(HtmlUtil.makeLink(PathParser.render(wikiPagePath), this.page.getName()));
        tagGroup.add(HtmlUtil.makeItalic(this.pageType()));
        return tagGroup.html();
    }

    public String getClassName(PageData pageData, Request request) throws Exception {
        String string = (String)request.getInput("className");
        if (string == null) {
            string = pageData.getVariable("TEST_RUNNER");
        }
        if (string == null) {
            string = "fit.FitServer";
        }
        return string;
    }

    protected String buildCommand(PageData pageData, String string, String string2) throws Exception {
        String string3 = pageData.getVariable("COMMAND_PATTERN");
        if (string3 == null) {
            string3 = DEFAULT_COMMAND_PATTERN;
        }
        String string4 = this.replace(string3, "%p", string2);
        string4 = this.replace(string4, "%m", string);
        return string4;
    }

    protected String replace(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + string3 + string.substring(n + string2.length());
    }

    public SecureOperation getSecureOperation() {
        return new SecureTestOperation();
    }

    protected String cssClassFor(Counts counts) {
        if (counts.wrong > 0) {
            return "fail";
        }
        if (counts.exceptions > 0 || counts.right + counts.ignores == 0) {
            return "error";
        }
        if (counts.ignores > 0 && counts.right == 0) {
            return "ignore";
        }
        return "pass";
    }

    protected int exitCode() {
        return this.assertionCounts.wrong + this.assertionCounts.exceptions;
    }

    public static void registerListener(TestEventListener testEventListener) {
        eventListeners.add(testEventListener);
    }
}

