/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fit.Counts;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.TagGroup;
import fitnesse.responders.run.ExecutionLog;

public class TestHtmlFormatter {
    private HtmlPage page;

    public TestHtmlFormatter(HtmlPage htmlPage) throws Exception {
        this.page = htmlPage;
        htmlPage.main.use("<!--BREAKPOINT-->");
        htmlPage.divide();
    }

    public String head() throws Exception {
        return this.page.preDivision + this.makeSummaryPlaceHolder().html();
    }

    private HtmlTag makeSummaryPlaceHolder() {
        HtmlTag htmlTag = new HtmlTag("div", "Running Tests ...");
        htmlTag.addAttribute("id", "test-summary");
        return htmlTag;
    }

    public String testSummary(Counts counts) throws Exception {
        String string = this.testPageSummary();
        string = string + "<strong>Assertions:</strong> " + counts.toString();
        HtmlTag htmlTag = new HtmlTag("script");
        htmlTag.add("document.getElementById(\"test-summary\").innerHTML = \"" + string + "\";");
        htmlTag.add("document.getElementById(\"test-summary\").className = \"" + this.cssClassFor(counts) + "\";");
        return htmlTag.html();
    }

    protected String testPageSummary() {
        return "";
    }

    protected String cssClassFor(Counts counts) {
        if (counts.wrong > 0) {
            return "fail";
        }
        if (counts.exceptions > 0 || counts.right + counts.ignores == 0) {
            return "error";
        }
        if (counts.ignores > 0 && counts.right == 0) {
            return "ignore";
        }
        return "pass";
    }

    public String tail() {
        return this.page.postDivision;
    }

    public String messageForBlankHtml() throws Exception {
        TagGroup tagGroup = new TagGroup();
        HtmlTag htmlTag = new HtmlTag("h2");
        htmlTag.addAttribute("class", "centered");
        htmlTag.add("Oops!  Did you forget to add to some content to this ?");
        tagGroup.add(htmlTag.html());
        tagGroup.add(HtmlUtil.HR.html());
        return tagGroup.html();
    }

    public String executionStatus(ExecutionLog executionLog) throws Exception {
        return executionLog.executionStatusHtml();
    }
}

