/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fit.Counts;
import fitnesse.components.ClassPathBuilder;
import fitnesse.components.FitClientListener;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.responders.run.SuiteHtmlFormatter;
import fitnesse.responders.run.TestResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageCrawlerImpl;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VirtualCouplingExtension;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class SuiteResponder
extends TestResponder
implements FitClientListener {
    public static final String SUITE_SETUP_NAME = "SuiteSetUp";
    public static final String SUITE_TEARDOWN_NAME = "SuiteTearDown";
    private LinkedList<WikiPage> processingQueue = new LinkedList();
    private WikiPage currentTest = null;
    private SuiteHtmlFormatter suiteFormatter;
    private List testPages;

    protected HtmlTag addSummaryPlaceHolder() {
        HtmlTag htmlTag = new HtmlTag("div", "Running Tests ...");
        htmlTag.addAttribute("id", "test-summary");
        return htmlTag;
    }

    protected void finishSending() throws Exception {
    }

    protected void performExecution() throws Exception {
        this.processTestPages(this.testPages);
        this.client.done();
        this.client.join();
        this.completeResponse();
    }

    protected void prepareForExecution() throws Exception {
        this.testPages = this.makePageList();
        this.classPath = SuiteResponder.buildClassPath(this.testPages, this.page);
    }

    private void processTestPages(List list) throws Exception {
        for (WikiPage wikiPage : list) {
            this.processingQueue.addLast(wikiPage);
            String string = HtmlUtil.testableHtml(wikiPage.getData());
            if (string.length() > 0) {
                this.client.send(string);
                continue;
            }
            this.client.send("OH NO! This page is empty!");
        }
    }

    protected void close() throws Exception {
        this.response.add(this.suiteFormatter.testOutput());
        this.response.add(this.suiteFormatter.tail());
        this.response.closeChunks();
        this.response.addTrailingHeader("Exit-Code", String.valueOf(this.exitCode()));
        this.response.closeTrailer();
        this.response.close();
    }

    public void acceptOutput(String string) throws Exception {
        WikiPage wikiPage;
        WikiPage wikiPage2 = wikiPage = this.processingQueue.isEmpty() ? null : this.processingQueue.getFirst();
        if (wikiPage != null && wikiPage != this.currentTest) {
            PageCrawler pageCrawler = this.page.getPageCrawler();
            String string2 = pageCrawler.getRelativeName(this.page, wikiPage);
            WikiPagePath wikiPagePath = pageCrawler.getFullPath(wikiPage);
            String string3 = PathParser.render(wikiPagePath);
            this.suiteFormatter.startOutputForNewTest(string2, string3);
            this.currentTest = wikiPage;
        }
        this.suiteFormatter.acceptOutput(string);
    }

    public void acceptResults(Counts counts) throws Exception {
        super.acceptResults(counts);
        PageCrawler pageCrawler = this.page.getPageCrawler();
        WikiPage wikiPage = this.processingQueue.removeFirst();
        String string = pageCrawler.getRelativeName(this.page, wikiPage);
        this.addToResponse(this.suiteFormatter.acceptResults(string, counts));
    }

    protected void makeFormatter() throws Exception {
        this.suiteFormatter = new SuiteHtmlFormatter(this.html);
        this.formatter = this.suiteFormatter;
    }

    protected String pageType() {
        return "Suite Results";
    }

    public static String buildClassPath(List list, WikiPage wikiPage) throws Exception {
        ClassPathBuilder classPathBuilder = new ClassPathBuilder();
        String string = classPathBuilder.getPathSeparator(wikiPage);
        ArrayList arrayList = new ArrayList();
        HashSet hashSet = new HashSet();
        for (WikiPage wikiPage2 : list) {
            SuiteResponder.addClassPathElements(wikiPage2, arrayList, hashSet);
        }
        return classPathBuilder.createClassPathString(arrayList, string);
    }

    private static void addClassPathElements(WikiPage wikiPage, List list, Set set) throws Exception {
        List list2 = new ClassPathBuilder().getInheritedPathElements(wikiPage, set);
        list.addAll(list2);
    }

    public List makePageList() throws Exception {
        return SuiteResponder.makePageList(this.page, this.root);
    }

    public static List makePageList(WikiPage wikiPage, WikiPage wikiPage2) throws Exception {
        WikiPage wikiPage3;
        LinkedList linkedList = SuiteResponder.getAllTestPagesUnder(wikiPage);
        List list = SuiteResponder.gatherCrossReferencedTestPages(wikiPage, wikiPage2);
        linkedList.addAll(list);
        WikiPage wikiPage4 = PageCrawlerImpl.getInheritedPage(SUITE_SETUP_NAME, wikiPage);
        if (wikiPage4 != null) {
            if (linkedList.contains(wikiPage4)) {
                linkedList.remove(wikiPage4);
            }
            linkedList.addFirst(wikiPage4);
        }
        if ((wikiPage3 = PageCrawlerImpl.getInheritedPage(SUITE_TEARDOWN_NAME, wikiPage)) != null) {
            if (linkedList.contains(wikiPage3)) {
                linkedList.remove(wikiPage3);
            }
            linkedList.addLast(wikiPage3);
        }
        return linkedList;
    }

    public static LinkedList getAllTestPagesUnder(WikiPage wikiPage) throws Exception {
        LinkedList linkedList = new LinkedList();
        SuiteResponder.addTestPagesToList(linkedList, wikiPage);
        Collections.sort(linkedList, new Comparator(){

            public int compare(Object object, Object object2) {
                try {
                    PageCrawler pageCrawler = ((WikiPage)object).getPageCrawler();
                    WikiPagePath wikiPagePath = pageCrawler.getFullPath((WikiPage)object);
                    WikiPagePath wikiPagePath2 = pageCrawler.getFullPath((WikiPage)object2);
                    return wikiPagePath.compareTo(wikiPagePath2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return 0;
                }
            }
        });
        return linkedList;
    }

    private static void addTestPagesToList(List list, WikiPage wikiPage) throws Exception {
        if (wikiPage.getData().hasAttribute("Test")) {
            list.add(wikiPage);
        }
        ArrayList<WikiPage> arrayList = new ArrayList<WikiPage>();
        arrayList.addAll(wikiPage.getChildren());
        if (wikiPage.hasExtension("VirtualCoupling")) {
            VirtualCouplingExtension virtualCouplingExtension = (VirtualCouplingExtension)wikiPage.getExtension("VirtualCoupling");
            arrayList.addAll(virtualCouplingExtension.getVirtualCoupling().getChildren());
        }
        for (WikiPage wikiPage2 : arrayList) {
            SuiteResponder.addTestPagesToList(list, wikiPage2);
        }
    }

    public static List gatherCrossReferencedTestPages(WikiPage wikiPage, WikiPage wikiPage2) throws Exception {
        LinkedList<WikiPage> linkedList = new LinkedList<WikiPage>();
        PageData pageData = wikiPage.getData();
        List list = pageData.getXrefPages();
        PageCrawler pageCrawler = wikiPage.getPageCrawler();
        WikiPagePath wikiPagePath = pageCrawler.getFullPath(wikiPage);
        WikiPage wikiPage3 = pageCrawler.getPage(wikiPage2, wikiPagePath.parentPath());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            WikiPagePath wikiPagePath2 = PathParser.parse((String)iterator.next());
            WikiPage wikiPage4 = pageCrawler.getPage(wikiPage3, wikiPagePath2);
            if (wikiPage4 == null) continue;
            linkedList.add(wikiPage4);
        }
        return linkedList;
    }
}

