/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fit.Counts;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.TagGroup;
import fitnesse.responders.run.TestHtmlFormatter;

public class SuiteHtmlFormatter
extends TestHtmlFormatter {
    private static final String cssSuffix1 = "1";
    private static final String cssSuffix2 = "2";
    private Counts pageCounts = new Counts();
    private String cssSuffix = "1";
    private TagGroup testResultsGroup = new TagGroup();
    private HtmlTag currentOutputDiv;

    public SuiteHtmlFormatter(HtmlPage htmlPage) throws Exception {
        super(htmlPage);
        HtmlTag htmlTag = new HtmlTag("h2", "Test Output");
        htmlTag.addAttribute("class", "centered");
        this.testResultsGroup.add(htmlTag);
    }

    protected String testPageSummary() {
        return "<strong>Test Pages:</strong> " + this.pageCounts.toString() + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    }

    public void setPageAssertions(Counts counts) {
        this.pageCounts = counts;
    }

    public String acceptResults(String string, Counts counts) throws Exception {
        this.switchCssSuffix();
        HtmlTag htmlTag = HtmlUtil.makeDivTag("alternating_row_" + this.cssSuffix);
        htmlTag.add(HtmlUtil.makeSpanTag("test_summary_results " + this.cssClassFor(counts), counts.toString()));
        HtmlTag htmlTag2 = HtmlUtil.makeLink("#" + string, string);
        htmlTag2.addAttribute("class", "test_summary_link");
        htmlTag.add(htmlTag2);
        this.pageCounts.tallyPageCounts(counts);
        return htmlTag.html(2);
    }

    public void startOutputForNewTest(String string, String string2) throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeDivTag("test_output_name");
        HtmlTag htmlTag2 = HtmlUtil.makeLink(string2, string);
        htmlTag2.addAttribute("id", string);
        htmlTag.add(htmlTag2);
        this.testResultsGroup.add(htmlTag);
        this.currentOutputDiv = HtmlUtil.makeDivTag("alternating_block_" + this.cssSuffix);
        this.testResultsGroup.add(this.currentOutputDiv);
    }

    public void acceptOutput(String string) {
        this.currentOutputDiv.add(string);
    }

    public String testOutput() throws Exception {
        return this.testResultsGroup.html();
    }

    private void switchCssSuffix() {
        this.cssSuffix = cssSuffix1.equals(this.cssSuffix) ? cssSuffix2 : cssSuffix1;
    }
}

