/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.components.FitProtocol;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.responders.run.PuppetResponse;
import fitnesse.responders.run.ResponsePuppeteer;
import fitnesse.responders.run.SocketDealer;
import fitnesse.responders.run.SocketDoner;
import java.net.Socket;

public class SocketCatchingResponder
implements Responder,
SocketDoner,
ResponsePuppeteer {
    private int ticketNumber;
    private SocketDealer dealer;
    private Socket socket;
    private ResponseSender sender;
    private PuppetResponse response;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        this.dealer = fitNesseContext.socketDealer;
        this.ticketNumber = Integer.parseInt(request.getInput("ticket").toString());
        this.response = new PuppetResponse(this);
        return this.response;
    }

    public void readyToSend(ResponseSender responseSender) throws Exception {
        this.socket = responseSender.getSocket();
        this.sender = responseSender;
        if (this.dealer.isWaiting(this.ticketNumber)) {
            this.dealer.dealSocketTo(this.ticketNumber, this);
        } else {
            String string = "There are no clients waiting for a socket with ticketNumber " + this.ticketNumber;
            FitProtocol.writeData(string, this.socket.getOutputStream());
            this.response.setStatus(404);
            responseSender.close();
        }
    }

    public Socket donateSocket() {
        return this.socket;
    }

    public void finishedWithSocket() throws Exception {
        this.sender.close();
    }
}

