/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fit.Counts;
import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.components.ClassPathBuilder;
import fitnesse.components.FitClient;
import fitnesse.components.FitClientListener;
import fitnesse.components.FitProtocol;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.responders.run.PuppetResponse;
import fitnesse.responders.run.ResponsePuppeteer;
import fitnesse.responders.run.SuiteResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VirtualEnabledPageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.net.Socket;
import java.util.List;

public class FitClientResponder
implements Responder,
ResponsePuppeteer,
FitClientListener {
    private FitNesseContext context;
    private PageCrawler crawler;
    private String resource;
    private WikiPage page;
    private boolean shouldIncludePaths;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        this.context = fitNesseContext;
        this.crawler = fitNesseContext.root.getPageCrawler();
        this.crawler.setDeadEndStrategy(new VirtualEnabledPageCrawler());
        this.resource = request.getResource();
        this.shouldIncludePaths = request.hasInput("includePaths");
        return new PuppetResponse(this);
    }

    public void readyToSend(ResponseSender responseSender) throws Exception {
        Socket socket = responseSender.getSocket();
        WikiPagePath wikiPagePath = PathParser.parse(this.resource);
        if (!this.crawler.pageExists(this.context.root, wikiPagePath)) {
            FitProtocol.writeData(this.notFoundMessage(), socket.getOutputStream());
        } else {
            this.page = this.crawler.getPage(this.context.root, wikiPagePath);
            PageData pageData = this.page.getData();
            if (pageData.hasAttribute("Suite")) {
                this.handleSuitePage(socket, this.page, this.context.root);
            } else if (pageData.hasAttribute("Test")) {
                this.handleTestPage(socket, pageData);
            } else {
                FitProtocol.writeData(this.notATestMessage(), socket.getOutputStream());
            }
        }
        responseSender.close();
    }

    private void handleTestPage(Socket socket, PageData pageData) throws Exception {
        FitClient fitClient = this.startClient(socket);
        if (this.shouldIncludePaths) {
            String string = new ClassPathBuilder().getClasspath(this.page);
            fitClient.send(string);
        }
        this.sendPage(pageData, fitClient);
        this.closeClient(fitClient);
    }

    private void handleSuitePage(Socket socket, WikiPage wikiPage, WikiPage wikiPage2) throws Exception {
        FitClient fitClient = this.startClient(socket);
        List list = SuiteResponder.makePageList(wikiPage, wikiPage2);
        if (this.shouldIncludePaths) {
            String string = SuiteResponder.buildClassPath(list, wikiPage);
            fitClient.send(string);
        }
        for (WikiPage wikiPage3 : list) {
            PageData pageData = wikiPage3.getData();
            this.sendPage(pageData, fitClient);
        }
        this.closeClient(fitClient);
    }

    private void sendPage(PageData pageData, FitClient fitClient) throws Exception {
        String string = this.crawler.getRelativeName(this.page, pageData.getWikiPage());
        String string2 = HtmlUtil.testableHtml(pageData);
        String string3 = string + "\n" + string2;
        fitClient.send(string3);
    }

    private void closeClient(FitClient fitClient) throws Exception {
        fitClient.done();
        fitClient.join();
    }

    private FitClient startClient(Socket socket) throws Exception {
        FitClient fitClient = new FitClient(this);
        fitClient.acceptSocket(socket);
        return fitClient;
    }

    private String notATestMessage() {
        return this.resource + " is neither a Test page nor a Suite page.";
    }

    private String notFoundMessage() {
        return "The page " + this.resource + " was not found.";
    }

    public void acceptOutput(String string) throws Exception {
    }

    public void acceptResults(Counts counts) throws Exception {
    }

    public void exceptionOccurred(Exception exception) {
    }
}

