/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.components.CommandRunner;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.run.ExecutionStatus;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VirtualEnabledPageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class ExecutionLog {
    public static final String ErrorLogName = "ErrorLogs";
    private PageCrawler crawler;
    private String errorLogPageName;
    private WikiPagePath errorLogPagePath;
    private WikiPage root;
    private CommandRunner runner;
    private List reasons = new LinkedList();
    private List exceptions = new LinkedList();

    public static SimpleDateFormat makeDateFormat() {
        return new SimpleDateFormat("h:mm:ss a (z) 'on' EEEE, MMMM d, yyyy");
    }

    public ExecutionLog(WikiPage wikiPage, CommandRunner commandRunner) throws Exception {
        this.runner = commandRunner;
        this.crawler = wikiPage.getPageCrawler();
        this.crawler.setDeadEndStrategy(new VirtualEnabledPageCrawler());
        this.root = this.crawler.getRoot(wikiPage);
        this.errorLogPagePath = this.crawler.getFullPath(wikiPage).addNameToFront(ErrorLogName);
        this.errorLogPageName = PathParser.render(this.errorLogPagePath);
    }

    public void addException(Exception exception) {
        this.exceptions.add(exception);
    }

    public void addReason(String string) {
        if (!this.reasons.contains(string)) {
            this.reasons.add(string);
        }
    }

    public void publish() throws Exception {
        String string = this.buildLogContent();
        WikiPage wikiPage = this.crawler.addPage(this.root, this.errorLogPagePath);
        PageData pageData = wikiPage.getData();
        pageData.setContent(string);
        wikiPage.commit(pageData);
    }

    public String buildLogContent() {
        StringBuffer stringBuffer = new StringBuffer();
        this.addEntry(stringBuffer, "Date", ExecutionLog.makeDateFormat().format(new Date()));
        this.addEntry(stringBuffer, "Command", this.runner.getCommand());
        this.addEntry(stringBuffer, "Exit code", String.valueOf(this.runner.getExitCode()));
        this.addEntry(stringBuffer, "Time elapsed", (double)this.runner.getExecutionTime() / 1000.0 + " seconds");
        if (this.runner.wroteToOutputStream()) {
            this.addOutputBlock(stringBuffer);
        }
        if (this.runner.wroteToErrorStream()) {
            this.addErrorBlock(stringBuffer);
        }
        if (this.runner.hasExceptions() || this.exceptions.size() > 0) {
            this.addExceptionBlock(stringBuffer);
        }
        String string = stringBuffer.toString();
        return string;
    }

    private void addEntry(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("|'''").append(string).append(": '''|").append("!-").append(string2).append("-!").append("|\n");
    }

    private void addOutputBlock(StringBuffer stringBuffer) {
        stringBuffer.append("----");
        stringBuffer.append("'''Standard Output:'''").append("\n");
        stringBuffer.append("{{{").append(this.runner.getOutput()).append("}}}");
    }

    private void addErrorBlock(StringBuffer stringBuffer) {
        stringBuffer.append("----");
        stringBuffer.append("'''Standard Error:'''").append("\n");
        stringBuffer.append("{{{").append(this.runner.getError()).append("}}}");
    }

    private void addExceptionBlock(StringBuffer stringBuffer) {
        this.exceptions.addAll(this.runner.getExceptions());
        stringBuffer.append("----");
        stringBuffer.append("'''Internal Exception");
        if (this.exceptions.size() > 1) {
            stringBuffer.append("s");
        }
        stringBuffer.append(":'''").append("\n");
        for (Exception exception : this.exceptions) {
            stringBuffer.append("{{{ ").append(ErrorResponder.makeExceptionString(exception)).append("}}}");
        }
    }

    public int exceptionCount() {
        return this.exceptions.size();
    }

    public String getErrorLogPageName() {
        return this.errorLogPageName;
    }

    public boolean hasCapturedOutput() {
        return this.runner.wroteToErrorStream() || this.runner.wroteToOutputStream();
    }

    public String executionStatusHtml() throws Exception {
        String string = this.getErrorLogPageName();
        return this.executionStatusHtml(string, "");
    }

    public String executionStatusHtml(String string, String string2) throws Exception {
        ExecutionStatus executionStatus = this.exceptionCount() > 0 ? ExecutionStatus.ERROR : (this.hasCapturedOutput() ? ExecutionStatus.OUTPUT : ExecutionStatus.OK);
        HtmlTag htmlTag = new HtmlTag("div");
        htmlTag.addAttribute("id", "execution-status");
        HtmlTag htmlTag2 = new HtmlTag("img");
        htmlTag2.addAttribute("src", string2 + "/files/images/executionStatus/" + executionStatus.getIconFilename());
        htmlTag.add(HtmlUtil.makeLink(string, htmlTag2.html()));
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(HtmlUtil.makeLink(string, executionStatus.getMessage()));
        return htmlTag.html();
    }
}

