/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.components.PageReferenceRenamer;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.SecureResponder;
import fitnesse.responders.refactoring.MovePageResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.widgets.WikiWordWidget;
import java.util.List;

public class RenamePageResponder
implements SecureResponder {
    private String qualifiedName;
    private String newName;
    private boolean refactorReferences;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        Response response;
        this.qualifiedName = request.getResource();
        this.newName = (String)request.getInput("newName");
        this.refactorReferences = request.hasInput("refactorReferences");
        if (this.newName != null && !this.qualifiedName.equals("FrontPage") && WikiWordWidget.isSingleWikiWord(this.newName)) {
            WikiPagePath wikiPagePath;
            PageCrawler pageCrawler = fitNesseContext.root.getPageCrawler();
            WikiPage wikiPage = pageCrawler.getPage(fitNesseContext.root, wikiPagePath = PathParser.parse(this.qualifiedName));
            if (wikiPage == null) {
                response = new NotFoundResponder().makeResponse(fitNesseContext, request);
            } else {
                WikiPagePath wikiPagePath2 = wikiPagePath.parentPath();
                WikiPage wikiPage2 = pageCrawler.getPage(fitNesseContext.root, wikiPagePath2);
                boolean bl = pageCrawler.pageExists(wikiPage2, PathParser.parse(this.newName));
                if (!bl) {
                    this.qualifiedName = this.doRename(fitNesseContext.root, wikiPage, wikiPage2, this.newName, wikiPagePath);
                    response = new SimpleResponse();
                    response.redirect(this.qualifiedName);
                } else {
                    response = this.makeErrorMessageResponder(this.makeLink(this.newName) + " already exists").makeResponse(fitNesseContext, request);
                }
            }
        } else {
            response = this.makeErrorMessageResponder(this.newName + " is not a valid simple page name.").makeResponse(fitNesseContext, request);
        }
        return response;
    }

    private Responder makeErrorMessageResponder(String string) throws Exception {
        return new ErrorResponder("Cannot rename " + this.makeLink(this.qualifiedName) + " to " + this.newName + "<br>" + string);
    }

    private String makeLink(String string) throws Exception {
        return HtmlUtil.makeLink(string, string).html();
    }

    private String doRename(WikiPage wikiPage, WikiPage wikiPage2, WikiPage wikiPage3, String string, WikiPagePath wikiPagePath) throws Exception {
        if (this.refactorReferences) {
            this.renameReferences(wikiPage, wikiPage2, string);
        }
        RenamePageResponder.rename(wikiPage3, wikiPage2.getName(), string, wikiPage);
        wikiPagePath.pop();
        wikiPagePath.addName(string);
        return PathParser.render(wikiPagePath);
    }

    private void renameReferences(WikiPage wikiPage, WikiPage wikiPage2, String string) throws Exception {
        PageReferenceRenamer pageReferenceRenamer = new PageReferenceRenamer(wikiPage);
        pageReferenceRenamer.renameReferences(wikiPage2, string);
    }

    private static boolean rename(WikiPage wikiPage, String string, String string2, WikiPage wikiPage2) throws Exception {
        if (wikiPage.hasChildPage(string) && !wikiPage.hasChildPage(string2)) {
            WikiPage wikiPage3 = wikiPage.getChildPage(string);
            PageCrawler pageCrawler = wikiPage3.getPageCrawler();
            PageData pageData = wikiPage3.getData();
            WikiPage wikiPage4 = wikiPage.addChildPage(string2);
            wikiPage4.commit(pageData);
            List<WikiPage> list = wikiPage3.getChildren();
            for (WikiPage wikiPage5 : list) {
                MovePageResponder.movePage(wikiPage2, pageCrawler.getFullPath(wikiPage5), pageCrawler.getFullPath(wikiPage4));
            }
            wikiPage.removeChildPage(string);
            return true;
        }
        return false;
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

