/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.TagGroup;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.SecureResponder;

public class RefactorPageResponder
implements SecureResponder {
    private String resource;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        this.resource = request.getResource();
        SimpleResponse simpleResponse = new SimpleResponse();
        simpleResponse.setContent(this.html(fitNesseContext));
        return simpleResponse;
    }

    public String html(FitNesseContext fitNesseContext) throws Exception {
        HtmlPage htmlPage = fitNesseContext.htmlPageFactory.newPage();
        htmlPage.title.use("Refactor: " + this.resource);
        htmlPage.header.use(HtmlUtil.makeBreadCrumbsWithPageType(this.resource, "Refactor"));
        htmlPage.main.use(this.mainContent());
        return htmlPage.html();
    }

    private HtmlTag mainContent() throws Exception {
        TagGroup tagGroup = new TagGroup();
        tagGroup.add(this.deletePageForm());
        tagGroup.add(this.renamePageForm());
        tagGroup.add(this.movePageForm());
        return tagGroup;
    }

    private HtmlTag deletePageForm() throws Exception {
        TagGroup tagGroup = new TagGroup();
        tagGroup.add(this.makeHeaderTag("Delete:"));
        tagGroup.add("Delete this entire sub-wiki.");
        tagGroup.add(this.makeDeletePageForm());
        return tagGroup;
    }

    private HtmlTag makeHeaderTag(String string) throws Exception {
        return new HtmlTag("h3", string);
    }

    private HtmlTag makeDeletePageForm() throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeFormTag("get", this.resource);
        htmlTag.add(HtmlUtil.makeInputTag("submit", "", "Delete Page"));
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "responder", "deletePage"));
        return htmlTag;
    }

    private HtmlTag movePageForm() throws Exception {
        TagGroup tagGroup = new TagGroup();
        tagGroup.add(HtmlUtil.BR);
        tagGroup.add(this.makeHeaderTag("Move:"));
        tagGroup.add(this.makeMovePageForm());
        return tagGroup;
    }

    private HtmlTag makeMovePageForm() throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeFormTag("get", this.resource);
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "responder", "movePage"));
        htmlTag.add("New Location: ");
        htmlTag.add(HtmlUtil.makeInputTag("text", "newLocation", ""));
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(HtmlUtil.makeInputTag("checkbox", "refactorReferences"));
        htmlTag.add(" - Find all references to this page and change them accordingly (May take several minutes)");
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(HtmlUtil.makeInputTag("submit", "", "Move Page"));
        return htmlTag;
    }

    private HtmlTag renamePageForm() throws Exception {
        TagGroup tagGroup = new TagGroup();
        tagGroup.add(HtmlUtil.BR);
        tagGroup.add(this.makeHeaderTag("Rename:"));
        tagGroup.add(this.makeRenamePageForm());
        return tagGroup;
    }

    private HtmlTag makeRenamePageForm() throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeFormTag("get", this.resource);
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "responder", "renamePage"));
        htmlTag.add("  New Name: ");
        htmlTag.add(HtmlUtil.makeInputTag("text", "newName", ""));
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(HtmlUtil.makeInputTag("checkbox", "refactorReferences"));
        htmlTag.add(" - Find all references to this page and change them accordingly (May take several minutes)");
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(HtmlUtil.makeInputTag("submit", "", "Rename Page"));
        return htmlTag;
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

