/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.components.MovedPageReferenceRenamer;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.SecureResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.List;

public class MovePageResponder
implements SecureResponder {
    private String nameOfPageToBeMoved;
    private String newParentName;
    private boolean refactorReferences;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        this.newParentName = MovePageResponder.getNameofNewParent(request);
        this.refactorReferences = request.hasInput("refactorReferences");
        this.nameOfPageToBeMoved = request.getResource();
        WikiPagePath wikiPagePath = PathParser.parse(this.nameOfPageToBeMoved);
        PageCrawler pageCrawler = fitNesseContext.root.getPageCrawler();
        WikiPage wikiPage = pageCrawler.getPage(fitNesseContext.root, wikiPagePath);
        if (wikiPage == null) {
            return new NotFoundResponder().makeResponse(fitNesseContext, request);
        }
        WikiPagePath wikiPagePath2 = PathParser.parse(this.newParentName);
        WikiPage wikiPage2 = pageCrawler.getPage(fitNesseContext.root, wikiPagePath2);
        if (wikiPage2 == null) {
            return this.makeErrorMessageResponder(this.newParentName + " does not exist.").makeResponse(fitNesseContext, request);
        }
        if (this.pageCanBeMoved(wikiPage, wikiPage2, wikiPagePath, wikiPagePath2)) {
            if (this.refactorReferences) {
                this.refactorReferences(fitNesseContext, wikiPage);
            }
            MovePageResponder.movePage(fitNesseContext.root, pageCrawler.getFullPath(wikiPage), pageCrawler.getFullPath(wikiPage2));
            SimpleResponse simpleResponse = new SimpleResponse();
            simpleResponse.redirect(this.createRedirectionUrl(wikiPage2, wikiPage));
            return simpleResponse;
        }
        return this.makeErrorMessageResponder("").makeResponse(fitNesseContext, request);
    }

    private void refactorReferences(FitNesseContext fitNesseContext, WikiPage wikiPage) throws Exception {
        MovedPageReferenceRenamer movedPageReferenceRenamer = new MovedPageReferenceRenamer(fitNesseContext.root);
        movedPageReferenceRenamer.renameReferences(wikiPage, this.newParentName);
    }

    private static String getNameofNewParent(Request request) {
        String string = (String)request.getInput("newLocation");
        if (".".equals(string)) {
            string = "";
        }
        return string;
    }

    private boolean pageCanBeMoved(WikiPage wikiPage, WikiPage wikiPage2, WikiPagePath wikiPagePath, WikiPagePath wikiPagePath2) throws Exception {
        return !wikiPagePath.equals(wikiPagePath2) && !this.selfPage(wikiPagePath, wikiPagePath2) && this.targetPageDoesntExist(wikiPage.getName(), wikiPage2) && !this.pageIsAncestorOfNewParent(wikiPagePath, wikiPagePath2);
    }

    public boolean pageIsAncestorOfNewParent(WikiPagePath wikiPagePath, WikiPagePath wikiPagePath2) throws Exception {
        return wikiPagePath2.startsWith(wikiPagePath);
    }

    public String createRedirectionUrl(WikiPage wikiPage, WikiPage wikiPage2) throws Exception {
        PageCrawler pageCrawler = wikiPage2.getPageCrawler();
        if (pageCrawler.isRoot(wikiPage)) {
            return wikiPage2.getName();
        }
        return PathParser.render(pageCrawler.getFullPath(wikiPage).addName(wikiPage2.getName()));
    }

    public boolean selfPage(WikiPagePath wikiPagePath, WikiPagePath wikiPagePath2) throws Exception {
        WikiPagePath wikiPagePath3 = wikiPagePath.parentPath();
        return wikiPagePath3.equals(wikiPagePath2);
    }

    private Responder makeErrorMessageResponder(String string) throws Exception {
        return new ErrorResponder("Cannot move " + this.makeLink(this.nameOfPageToBeMoved) + " below " + this.newParentName + "<br>" + string);
    }

    private String makeLink(String string) throws Exception {
        return HtmlUtil.makeLink(string, string).html();
    }

    public static void movePage(WikiPage wikiPage, WikiPagePath wikiPagePath, WikiPagePath wikiPagePath2) throws Exception {
        PageCrawler pageCrawler = wikiPage.getPageCrawler();
        WikiPage wikiPage2 = pageCrawler.getPage(wikiPage, wikiPagePath);
        WikiPagePath wikiPagePath3 = wikiPagePath2.withNameAdded(wikiPage2.getName());
        WikiPage wikiPage3 = pageCrawler.addPage(wikiPage, wikiPagePath3, wikiPage2.getData().getContent());
        PageData pageData = wikiPage3.getData();
        PageData pageData2 = wikiPage2.getData();
        pageData.setProperties(pageData2.getProperties());
        pageData.getProperties().setLastModificationTime(pageData2.getProperties().getLastModificationTime());
        List<WikiPage> list = wikiPage2.getChildren();
        if (list.size() > 0) {
            MovePageResponder.moveChildren(list, wikiPage, wikiPagePath3);
        }
        wikiPage3.commit(pageData);
        WikiPagePath wikiPagePath4 = wikiPagePath.parentPath();
        WikiPage wikiPage4 = pageCrawler.getPage(wikiPage, wikiPagePath4);
        wikiPage4.removeChildPage(wikiPage2.getName());
    }

    private boolean targetPageDoesntExist(String string, WikiPage wikiPage) throws Exception {
        return !wikiPage.hasChildPage(string);
    }

    public static void moveChildren(List list, WikiPage wikiPage, WikiPagePath wikiPagePath) throws Exception {
        for (WikiPage wikiPage2 : list) {
            MovePageResponder.movePage(wikiPage, wikiPage2.getPageCrawler().getFullPath(wikiPage2), wikiPagePath);
        }
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

