/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.SecureResponder;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.List;

public class DeletePageResponder
implements SecureResponder {
    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        SimpleResponse simpleResponse = new SimpleResponse();
        String string = request.getResource();
        WikiPagePath wikiPagePath = PathParser.parse(string);
        if (string.equals("FrontPage")) {
            simpleResponse.redirect("FrontPage");
        } else {
            String string2 = (String)request.getInput("confirmed");
            if ("yes".equals(string2)) {
                String string3 = wikiPagePath.last();
                wikiPagePath.pop();
                WikiPage wikiPage = fitNesseContext.root.getPageCrawler().getPage(fitNesseContext.root, wikiPagePath);
                if (wikiPage != null) {
                    wikiPage.removeChildPage(string3);
                }
                this.redirect(wikiPagePath, simpleResponse);
            } else {
                simpleResponse.setContent(this.buildConfirmationHtml(fitNesseContext.root, string, fitNesseContext));
            }
        }
        return simpleResponse;
    }

    private void redirect(WikiPagePath wikiPagePath, SimpleResponse simpleResponse) {
        String string = PathParser.render(wikiPagePath);
        if (string == null || string.length() == 0) {
            simpleResponse.redirect("root");
        } else {
            simpleResponse.redirect(string);
        }
    }

    private String buildConfirmationHtml(WikiPage wikiPage, String string, FitNesseContext fitNesseContext) throws Exception {
        HtmlPage htmlPage = fitNesseContext.htmlPageFactory.newPage();
        htmlPage.title.use("Delete Confirmation");
        htmlPage.header.use(HtmlUtil.makeBreadCrumbsWithPageType(string, "/", "Confirm Deletion"));
        htmlPage.main.use(this.makeMainContent(wikiPage, string));
        return htmlPage.html();
    }

    private String makeMainContent(WikiPage wikiPage, String string) throws Exception {
        WikiPagePath wikiPagePath = PathParser.parse(string);
        WikiPage wikiPage2 = wikiPage.getPageCrawler().getPage(wikiPage, wikiPagePath);
        List<WikiPage> list = wikiPage2.getChildren();
        boolean bl = true;
        if (list == null || list.size() == 0) {
            bl = false;
        }
        HtmlTag htmlTag = HtmlUtil.makeDivTag("centered");
        htmlTag.add(this.makeHeadingTag(bl, string));
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(HtmlUtil.makeLink(string + "?responder=deletePage&confirmed=yes", "Yes"));
        htmlTag.add("&nbsp;&nbsp;&nbsp;&nbsp;");
        htmlTag.add(HtmlUtil.makeLink(string, "No"));
        return htmlTag.html();
    }

    private HtmlTag makeHeadingTag(boolean bl, String string) {
        HtmlTag htmlTag = new HtmlTag("H3");
        if (bl) {
            htmlTag.add("Warning, this page contains one or more subpages.");
            htmlTag.add(HtmlUtil.BR);
        }
        htmlTag.add("Are you sure you want to delete " + string + "?");
        return htmlTag;
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

