/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.http.UploadedFile;
import fitnesse.responders.SecureResponder;
import fitnesse.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UploadResponder
implements SecureResponder {
    private static final Pattern filenamePattern = Pattern.compile("([^/\\\\]*[/\\\\])*([^/\\\\]*)");
    private String rootPath;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        this.rootPath = fitNesseContext.rootPagePath;
        SimpleResponse simpleResponse = new SimpleResponse();
        String string = request.getResource().replace("%20", " ");
        UploadedFile uploadedFile = (UploadedFile)request.getInput("file");
        if (uploadedFile.isUsable()) {
            File file = this.makeFileToCreate(uploadedFile, string);
            this.writeFile(file, uploadedFile);
        }
        simpleResponse.redirect("/" + string.replace(" ", "%20"));
        return simpleResponse;
    }

    public void writeFile(File file, UploadedFile uploadedFile) throws Exception {
        boolean bl = uploadedFile.getFile().renameTo(file);
        if (!bl) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(uploadedFile.getFile()));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            FileUtil.copyBytes(bufferedInputStream, bufferedOutputStream);
            ((InputStream)bufferedInputStream).close();
            ((OutputStream)bufferedOutputStream).close();
            uploadedFile.delete();
        }
    }

    private File makeFileToCreate(UploadedFile uploadedFile, String string) {
        String string2;
        String string3 = string2 = UploadResponder.makeRelativeFilename(uploadedFile.getName());
        int n = 1;
        File file = new File(this.makeFullFilename(string, string3));
        while (file.exists()) {
            string3 = UploadResponder.makeNewFilename(string2, n++);
            file = new File(this.makeFullFilename(string, string3));
        }
        return file;
    }

    private String makeFullFilename(String string, String string2) {
        return this.rootPath + "/" + string + string2;
    }

    public static String makeRelativeFilename(String string) {
        Matcher matcher = filenamePattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return string;
    }

    public static String makeNewFilename(String string, int n) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 1) {
            return string + "_copy" + n;
        }
        String string2 = "";
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (i != 0) {
                string2 = string2 + ".";
            }
            string2 = string2 + stringArray[i];
        }
        string2 = string2 + "_copy" + n + "." + stringArray[stringArray.length - 1];
        return string2;
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

