/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.SecureResponder;

public class RenameFileConfirmationResponder
implements SecureResponder {
    private String resource;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        SimpleResponse simpleResponse = new SimpleResponse();
        this.resource = request.getResource();
        String string = (String)request.getInput("filename");
        simpleResponse.setContent(this.makePageContent(string, fitNesseContext));
        return simpleResponse;
    }

    private String makePageContent(String string, FitNesseContext fitNesseContext) throws Exception {
        HtmlPage htmlPage = fitNesseContext.htmlPageFactory.newPage();
        htmlPage.title.use("Rename " + string);
        htmlPage.header.use(HtmlUtil.makeBreadCrumbsWithPageType(this.resource + string, "/", "Rename File"));
        htmlPage.main.use(this.makeRenameFormHTML(string));
        return htmlPage.html();
    }

    private HtmlTag makeRenameFormHTML(String string) throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeFormTag("get", "/" + this.resource);
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "responder", "renameFile"));
        htmlTag.add("Rename " + HtmlUtil.makeBold(string).html() + " to ");
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(HtmlUtil.makeInputTag("text", "newName", string));
        htmlTag.add(HtmlUtil.makeInputTag("submit", "renameFile", "Rename"));
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "filename", string));
        return htmlTag;
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

