/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.http.InputStreamResponse;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.files.DirectoryResponder;
import java.io.File;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.Date;

public class FileResponder
implements Responder {
    private static FileNameMap fileNameMap = URLConnection.getFileNameMap();
    public String resource;
    public File requestedFile;
    public Date lastModifiedDate;
    public String lastModifiedDateString;

    public static Responder makeResponder(Request request, String string) throws Exception {
        File file;
        String string2 = request.getResource();
        if (FileResponder.fileNameHasSpaces(string2)) {
            string2 = FileResponder.restoreRealSpacesInFileName(string2);
        }
        if (!(file = new File(string + "/" + string2)).exists()) {
            return new NotFoundResponder();
        }
        if (file.isDirectory()) {
            return new DirectoryResponder(string2, file);
        }
        return new FileResponder(string2, file);
    }

    public FileResponder(String string, File file) {
        this.resource = string;
        this.requestedFile = file;
    }

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        InputStreamResponse inputStreamResponse = new InputStreamResponse();
        this.determineLastModifiedInfo();
        if (this.isNotModified(request)) {
            return this.createNotModifiedResponse();
        }
        inputStreamResponse.setBody(this.requestedFile);
        this.setContentType(this.requestedFile, inputStreamResponse);
        inputStreamResponse.setLastModifiedHeader(this.lastModifiedDateString);
        return inputStreamResponse;
    }

    public static boolean fileNameHasSpaces(String string) {
        return string.indexOf("%20") != 0;
    }

    public static String restoreRealSpacesInFileName(String string) throws Exception {
        return URLDecoder.decode(string, "UTF-8");
    }

    String getResource() {
        return this.resource;
    }

    private boolean isNotModified(Request request) {
        if (request.hasHeader("If-Modified-Since")) {
            String string = (String)request.getHeader("If-Modified-Since");
            try {
                Date date = SimpleResponse.makeStandardHttpDateFormat().parse(string);
                if (!date.before(this.lastModifiedDate)) {
                    return true;
                }
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
        return false;
    }

    private Response createNotModifiedResponse() {
        SimpleResponse simpleResponse = new SimpleResponse();
        simpleResponse.setStatus(304);
        simpleResponse.addHeader("Date", SimpleResponse.makeStandardHttpDateFormat().format(new Date()));
        simpleResponse.addHeader("Cache-Control", "private");
        simpleResponse.setLastModifiedHeader(this.lastModifiedDateString);
        return simpleResponse;
    }

    private void determineLastModifiedInfo() {
        this.lastModifiedDate = new Date(this.requestedFile.lastModified());
        this.lastModifiedDateString = SimpleResponse.makeStandardHttpDateFormat().format(this.lastModifiedDate);
        try {
            this.lastModifiedDate = SimpleResponse.makeStandardHttpDateFormat().parse(this.lastModifiedDateString);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
    }

    private void setContentType(File file, Response response) {
        String string = FileResponder.getContentType(file.getName());
        response.setContentType(string);
    }

    public static String getContentType(String string) {
        String string2 = fileNameMap.getContentTypeFor(string);
        if (string2 == null) {
            string2 = string.endsWith(".css") ? "text/css" : (string.endsWith(".jar") ? "application/x-java-archive" : "text/plain");
        }
        return string2;
    }
}

