/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTableListingBuilder;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.RawHtml;
import fitnesse.html.TagGroup;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.SecureResponder;
import fitnesse.util.FileUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DirectoryResponder
implements SecureResponder {
    private String resource;
    private File requestedDirectory;
    private FitNesseContext context;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy, hh:mm a");

    public DirectoryResponder(String string, File file) {
        this.resource = string;
        this.requestedDirectory = file;
    }

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        this.context = fitNesseContext;
        SimpleResponse simpleResponse = new SimpleResponse();
        if (!this.resource.endsWith("/")) {
            this.setRedirectForDirectory(simpleResponse);
        } else {
            simpleResponse.setContent(this.makeDirectoryListingPage());
        }
        return simpleResponse;
    }

    private void setRedirectForDirectory(Response response) {
        if (!this.resource.startsWith("/")) {
            this.resource = "/" + this.resource;
        }
        response.redirect(this.resource + "/");
    }

    private String makeDirectoryListingPage() throws Exception {
        HtmlPage htmlPage = this.context.htmlPageFactory.newPage();
        htmlPage.title.use("Files: " + this.resource);
        htmlPage.header.use(HtmlUtil.makeBreadCrumbsWithPageType(this.resource, "/", "Files Section"));
        htmlPage.actions.use(HtmlUtil.makeActionLink("/FrontPage", "FrontPage", null, "f", false));
        htmlPage.main.use(this.makeRightColumn());
        return htmlPage.html();
    }

    private String makeRightColumn() throws Exception {
        TagGroup tagGroup = new TagGroup();
        tagGroup.add(this.addFiles(FileUtil.getDirectoryListing(this.requestedDirectory)));
        tagGroup.add(HtmlUtil.HR.html());
        tagGroup.add(this.makeUploadForm());
        tagGroup.add(this.makeDirectoryForm());
        return tagGroup.html();
    }

    private HtmlTag addFiles(File[] fileArray) throws Exception {
        HtmlTableListingBuilder htmlTableListingBuilder = new HtmlTableListingBuilder();
        this.makeHeadingRow(htmlTableListingBuilder);
        this.addFileRows(fileArray, htmlTableListingBuilder);
        return htmlTableListingBuilder.getTable();
    }

    private void addFileRows(File[] fileArray, HtmlTableListingBuilder htmlTableListingBuilder) throws Exception {
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            HtmlTag htmlTag = this.makeLinkToFile(file);
            RawHtml rawHtml = new RawHtml(DirectoryResponder.getSizeString(file));
            RawHtml rawHtml2 = new RawHtml(this.dateFormat.format(new Date(file.lastModified())));
            TagGroup tagGroup = new TagGroup();
            tagGroup.add(this.makeRenameButton(file.getName()));
            tagGroup.add("|");
            tagGroup.add(this.makeDeleteButton(file.getName()));
            htmlTableListingBuilder.addRow(new HtmlElement[]{htmlTag, rawHtml, rawHtml2, tagGroup});
        }
    }

    private void makeHeadingRow(HtmlTableListingBuilder htmlTableListingBuilder) throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeSpanTag("caps", "Name");
        HtmlTag htmlTag2 = HtmlUtil.makeSpanTag("caps", "Size");
        HtmlTag htmlTag3 = HtmlUtil.makeSpanTag("caps", "Date");
        HtmlTag htmlTag4 = HtmlUtil.makeSpanTag("caps", "Action");
        htmlTableListingBuilder.addRow(new HtmlTag[]{htmlTag, htmlTag2, htmlTag3, htmlTag4});
    }

    private HtmlTag makeDeleteButton(String string) throws Exception {
        return HtmlUtil.makeLink("?responder=deleteConfirmation&filename=" + string, "Delete");
    }

    private HtmlTag makeRenameButton(String string) throws Exception {
        return HtmlUtil.makeLink("?responder=renameConfirmation&filename=" + string, "Rename");
    }

    private HtmlTag makeLinkToFile(File file) {
        String string = file.getName();
        if (file.isDirectory()) {
            string = string + "/";
            HtmlTag htmlTag = new HtmlTag("img");
            htmlTag.addAttribute("src", "/files/images/folder.gif");
            htmlTag.addAttribute("class", "left");
            HtmlTag htmlTag2 = HtmlUtil.makeLink(string, htmlTag);
            htmlTag2.add(file.getName());
            return htmlTag2;
        }
        return HtmlUtil.makeLink(string, file.getName());
    }

    private HtmlTag makeUploadForm() throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeFormTag("post", "/" + this.resource);
        htmlTag.addAttribute("enctype", "multipart/form-data");
        htmlTag.addAttribute("class", "left");
        htmlTag.add("<!--upload form-->");
        htmlTag.add(HtmlUtil.makeSpanTag("caps", "Upload a file:"));
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "responder", "upload"));
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(HtmlUtil.makeInputTag("file", "file", ""));
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(HtmlUtil.makeInputTag("submit", "", "Upload"));
        return htmlTag;
    }

    private HtmlTag makeDirectoryForm() throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeFormTag("get", "/" + this.resource);
        htmlTag.addAttribute("class", "right");
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "responder", "createDir"));
        htmlTag.add("<!--create directory form-->");
        htmlTag.add(HtmlUtil.makeSpanTag("caps", "Create a directory:"));
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(HtmlUtil.makeInputTag("text", "dirname", ""));
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(HtmlUtil.makeInputTag("submit", "", "Create"));
        return htmlTag;
    }

    public static String getSizeString(File file) {
        if (file.isDirectory()) {
            return "";
        }
        return file.length() + " bytes";
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

