/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.TagGroup;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.SecureResponder;
import java.io.File;

public class DeleteConfirmationResponder
implements SecureResponder {
    private String resource;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        SimpleResponse simpleResponse = new SimpleResponse();
        this.resource = request.getResource();
        String string = (String)request.getInput("filename");
        simpleResponse.setContent(this.makeDirectoryListingPage(string, fitNesseContext));
        simpleResponse.setLastModifiedHeader("Delete");
        return simpleResponse;
    }

    private String makeDirectoryListingPage(String string, FitNesseContext fitNesseContext) throws Exception {
        HtmlPage htmlPage = fitNesseContext.htmlPageFactory.newPage();
        htmlPage.title.use("Delete File(s): ");
        htmlPage.header.use(HtmlUtil.makeBreadCrumbsWithPageType(this.resource + string, "/", "Delete File"));
        htmlPage.main.use(this.makeConfirmationHTML(string, fitNesseContext));
        return htmlPage.html();
    }

    private HtmlTag makeConfirmationHTML(String string, FitNesseContext fitNesseContext) throws Exception {
        String string2 = fitNesseContext.rootPagePath + "/" + this.resource + string;
        File file = new File(string2);
        boolean bl = file.isDirectory();
        TagGroup tagGroup = new TagGroup();
        tagGroup.add(this.messageText(string, bl, file));
        tagGroup.add(HtmlUtil.BR);
        tagGroup.add(HtmlUtil.BR);
        tagGroup.add(HtmlUtil.BR);
        tagGroup.add(this.makeYesForm(string));
        tagGroup.add(this.makeNoForm());
        tagGroup.add(HtmlUtil.NBSP);
        tagGroup.add(HtmlUtil.NBSP);
        return tagGroup;
    }

    private String messageText(String string, boolean bl, File file) {
        String string2 = "Are you sure you would like to delete <b>" + string + "</b> ";
        if (bl) {
            string2 = string2 + " and all " + file.listFiles().length + " files inside";
        }
        return string2 + "?";
    }

    private HtmlTag makeNoForm() {
        HtmlTag htmlTag = HtmlUtil.makeFormTag("get", "/" + this.resource);
        htmlTag.add(HtmlUtil.makeInputTag("submit", "", "No"));
        return htmlTag;
    }

    private HtmlTag makeYesForm(String string) {
        HtmlTag htmlTag = HtmlUtil.makeFormTag("get", "/" + this.resource);
        htmlTag.add(HtmlUtil.makeInputTag("submit", "", "Yes"));
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "responder", "deleteFile"));
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "filename", string));
        return htmlTag;
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

