/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import java.io.File;

public class SymbolicLinkResponder
implements Responder {
    private Response response;
    private String resource;
    private PageCrawler crawler;
    private FitNesseContext context;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        this.resource = request.getResource();
        this.context = fitNesseContext;
        this.crawler = fitNesseContext.root.getPageCrawler();
        WikiPage wikiPage = this.crawler.getPage(fitNesseContext.root, PathParser.parse(this.resource));
        if (wikiPage == null) {
            return new NotFoundResponder().makeResponse(fitNesseContext, request);
        }
        this.response = new SimpleResponse();
        if (request.hasInput("removal")) {
            this.removeSymbolicLink(request, wikiPage);
        } else {
            this.addSymbolicLink(request, wikiPage);
        }
        return this.response;
    }

    private void setRedirect(String string) {
        this.response.redirect(string + "?properties");
    }

    private void removeSymbolicLink(Request request, WikiPage wikiPage) throws Exception {
        String string = (String)request.getInput("removal");
        PageData pageData = wikiPage.getData();
        WikiPageProperties wikiPageProperties = pageData.getProperties();
        WikiPageProperty wikiPageProperty = this.getSymLinkProperty(wikiPageProperties);
        wikiPageProperty.remove(string);
        if (wikiPageProperty.keySet().size() == 0) {
            wikiPageProperties.remove("SymbolicLinks");
        }
        wikiPage.commit(pageData);
        this.setRedirect(this.resource);
    }

    private void addSymbolicLink(Request request, WikiPage wikiPage) throws Exception {
        String string = (String)request.getInput("linkName");
        String string2 = (String)request.getInput("linkPath");
        if (this.isFilePath(string2) && !this.isValidDirectoryPath(string2)) {
            String string3 = "Cannot create link to the file system path, <b>" + string2 + "</b>." + "<br> The canonical file system path used was <b>" + this.createFileFromPath(string2).getCanonicalPath() + ".</b>" + "<br>Either it doesn't exist or it's not a directory.";
            this.response = new ErrorResponder(string3).makeResponse(this.context, null);
            this.response.setStatus(404);
        } else if (!this.isFilePath(string2) && this.isInternalPageThatDoesntExist(string2)) {
            this.response = new ErrorResponder("The page to which you are attemting to link, " + string2 + ", doesn't exist.").makeResponse(this.context, null);
            this.response.setStatus(404);
        } else if (wikiPage.hasChildPage(string)) {
            this.response = new ErrorResponder(this.resource + " already has a child named " + string + ".").makeResponse(this.context, null);
            this.response.setStatus(412);
        } else {
            PageData pageData = wikiPage.getData();
            WikiPageProperties wikiPageProperties = pageData.getProperties();
            WikiPageProperty wikiPageProperty = this.getSymLinkProperty(wikiPageProperties);
            wikiPageProperty.set(string, string2);
            wikiPage.commit(pageData);
            this.setRedirect(this.resource);
        }
    }

    private boolean isValidDirectoryPath(String string) throws Exception {
        File file = this.createFileFromPath(string);
        if (file.exists()) {
            return file.isDirectory();
        }
        File file2 = file.getParentFile();
        return file2.exists() && file2.isDirectory();
    }

    private File createFileFromPath(String string) {
        String string2 = string.substring(7);
        return new File(string2);
    }

    private boolean isFilePath(String string) {
        return string.startsWith("file://");
    }

    private boolean isInternalPageThatDoesntExist(String string) throws Exception {
        return !this.crawler.pageExists(this.context.root, PathParser.parse(string));
    }

    private WikiPageProperty getSymLinkProperty(WikiPageProperties wikiPageProperties) {
        WikiPageProperty wikiPageProperty = wikiPageProperties.getProperty("SymbolicLinks");
        if (wikiPageProperty == null) {
            wikiPageProperty = wikiPageProperties.set("SymbolicLinks");
        }
        return wikiPageProperty;
    }
}

