/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureWriteOperation;
import fitnesse.components.RecentChanges;
import fitnesse.components.SaveRecorder;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.SecureResponder;
import fitnesse.responders.editing.ContentFilter;
import fitnesse.responders.editing.MergeResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public class SaveResponder
implements SecureResponder {
    public static ContentFilter contentFilter;
    private String user;
    private long ticketId;
    private String savedContent;
    private PageData data;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        String string = request.getResource();
        WikiPage wikiPage = this.getPage(string, fitNesseContext);
        this.data = wikiPage.getData();
        this.user = request.getAuthorizationUsername();
        if (this.editsNeedMerge(request)) {
            return new MergeResponder(request).makeResponse(fitNesseContext, request);
        }
        this.savedContent = (String)request.getInput("pageContent");
        if (contentFilter != null && !contentFilter.isContentAcceptable(this.savedContent, string)) {
            return this.makeBannedContentResponse(fitNesseContext, string);
        }
        return this.saveEdits(request, wikiPage);
    }

    private Response makeBannedContentResponse(FitNesseContext fitNesseContext, String string) throws Exception {
        SimpleResponse simpleResponse = new SimpleResponse();
        HtmlPage htmlPage = fitNesseContext.htmlPageFactory.newPage();
        htmlPage.title.use("Edit " + string);
        htmlPage.header.use(HtmlUtil.makeBreadCrumbsWithPageType(string, "Banned Content"));
        htmlPage.main.use(new HtmlTag("h3", "The content you're trying to save has been banned from this site.  Your changes will not be saved!"));
        simpleResponse.setContent(htmlPage.html());
        return simpleResponse;
    }

    private Response saveEdits(Request request, WikiPage wikiPage) throws Exception {
        SimpleResponse simpleResponse = new SimpleResponse();
        this.setData();
        VersionInfo versionInfo = wikiPage.commit(this.data);
        simpleResponse.addHeader("Previous-Version", versionInfo.getName());
        RecentChanges.updateRecentChanges(this.data);
        if (request.hasInput("redirect")) {
            simpleResponse.redirect(request.getInput("redirect").toString());
        } else {
            simpleResponse.redirect(request.getResource());
        }
        return simpleResponse;
    }

    private boolean editsNeedMerge(Request request) throws Exception {
        String string = (String)request.getInput("saveId");
        long l = Long.parseLong(string);
        String string2 = (String)request.getInput("ticketId");
        this.ticketId = Long.parseLong(string2);
        return SaveRecorder.changesShouldBeMerged(l, this.ticketId, this.data);
    }

    private WikiPage getPage(String string, FitNesseContext fitNesseContext) throws Exception {
        WikiPagePath wikiPagePath = PathParser.parse(string);
        PageCrawler pageCrawler = fitNesseContext.root.getPageCrawler();
        WikiPage wikiPage = pageCrawler.getPage(fitNesseContext.root, wikiPagePath);
        if (wikiPage == null) {
            wikiPage = pageCrawler.addPage(fitNesseContext.root, PathParser.parse(string));
        }
        return wikiPage;
    }

    private void setData() throws Exception {
        this.data.setContent(this.savedContent);
        this.data.setAttribute("ticketId", this.ticketId + "");
        SaveRecorder.pageSaved(this.data);
        if (this.user != null) {
            this.data.setAttribute("LastModifyingUser", this.user);
        } else {
            this.data.removeAttribute("LastModifyingUser");
        }
    }

    public SecureOperation getSecureOperation() {
        return new SecureWriteOperation();
    }
}

