/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.components.RecentChanges;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.SecureResponder;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.VirtualCouplingExtension;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.Arrays;
import java.util.LinkedList;

public class SavePropertiesResponder
implements SecureResponder {
    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        SimpleResponse simpleResponse = new SimpleResponse();
        String string = request.getResource();
        WikiPagePath wikiPagePath = PathParser.parse(string);
        WikiPage wikiPage = fitNesseContext.root.getPageCrawler().getPage(fitNesseContext.root, wikiPagePath);
        if (wikiPage == null) {
            return new NotFoundResponder().makeResponse(fitNesseContext, request);
        }
        PageData pageData = wikiPage.getData();
        this.saveAttributes(request, pageData);
        VersionInfo versionInfo = wikiPage.commit(pageData);
        simpleResponse.addHeader("Previous-Version", versionInfo.getName());
        RecentChanges.updateRecentChanges(pageData);
        simpleResponse.redirect(string);
        return simpleResponse;
    }

    private void saveAttributes(Request request, PageData pageData) throws Exception {
        WikiPage wikiPage;
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(Arrays.asList(WikiPage.NON_SECURITY_ATTRIBUTES));
        linkedList.addAll(Arrays.asList(WikiPage.SECURITY_ATTRIBUTES));
        for (String object2 : linkedList) {
            if (this.isChecked(request, object2)) {
                pageData.setAttribute(object2);
                continue;
            }
            pageData.removeAttribute(object2);
        }
        String string = (String)request.getInput("VirtualWiki");
        if (!string.equals(pageData.getAttribute("VirtualWiki")) && (wikiPage = pageData.getWikiPage()).hasExtension("VirtualCoupling")) {
            VirtualCouplingExtension virtualCouplingExtension = (VirtualCouplingExtension)wikiPage.getExtension("VirtualCoupling");
            virtualCouplingExtension.resetVirtualCoupling();
        }
        if ("".equals(string) || string == null) {
            pageData.removeAttribute("VirtualWiki");
        } else {
            pageData.setAttribute("VirtualWiki", string);
        }
    }

    private boolean isChecked(Request request, String string) {
        return request.getInput(string) != null;
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

