/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTableListingBuilder;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.RawHtml;
import fitnesse.html.TagGroup;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.SecureResponder;
import fitnesse.responders.WikiImportProperty;
import fitnesse.wiki.MockingPageCrawler;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperty;
import java.util.Set;

public class PropertiesResponder
implements SecureResponder {
    private WikiPage page;
    public PageData pageData;
    private String resource;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        SimpleResponse simpleResponse = new SimpleResponse();
        this.resource = request.getResource();
        WikiPagePath wikiPagePath = PathParser.parse(this.resource);
        PageCrawler pageCrawler = fitNesseContext.root.getPageCrawler();
        if (!pageCrawler.pageExists(fitNesseContext.root, wikiPagePath)) {
            pageCrawler.setDeadEndStrategy(new MockingPageCrawler());
            this.page = pageCrawler.getPage(fitNesseContext.root, wikiPagePath);
        } else {
            this.page = pageCrawler.getPage(fitNesseContext.root, wikiPagePath);
        }
        if (this.page == null) {
            return new NotFoundResponder().makeResponse(fitNesseContext, request);
        }
        this.pageData = this.page.getData();
        String string = this.makeHtml(fitNesseContext);
        simpleResponse.setContent(string);
        simpleResponse.setMaxAge(0);
        return simpleResponse;
    }

    private String makeHtml(FitNesseContext fitNesseContext) throws Exception {
        HtmlPage htmlPage = fitNesseContext.htmlPageFactory.newPage();
        htmlPage.title.use("Properties: " + this.resource);
        htmlPage.header.use(HtmlUtil.makeBreadCrumbsWithPageType(this.resource, "Page Properties"));
        htmlPage.main.use(this.makeLastModifiedTag());
        htmlPage.main.add(this.makeFormSections());
        return htmlPage.html();
    }

    private HtmlTag makeAttributeCheckbox(String string, PageData pageData) throws Exception {
        HtmlTag htmlTag = this.makeCheckbox(string);
        if (pageData.hasAttribute(string)) {
            htmlTag.addAttribute("checked", "true");
        }
        return htmlTag;
    }

    private HtmlTag makeCheckbox(String string) {
        HtmlTag htmlTag = HtmlUtil.makeInputTag("checkbox", string);
        htmlTag.tail = " - " + string;
        return htmlTag;
    }

    private HtmlTag makeLastModifiedTag() throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeDivTag("right");
        String string = this.pageData.getAttribute("LastModifyingUser");
        if (string == null || "".equals(string)) {
            htmlTag.use("Last modified anonymously");
        } else {
            htmlTag.use("Last modified by " + string);
        }
        return htmlTag;
    }

    private HtmlTag makeFormSections() throws Exception {
        TagGroup tagGroup = new TagGroup();
        tagGroup.add(this.makePropertiesForm());
        WikiImportProperty wikiImportProperty = WikiImportProperty.createFrom(this.pageData.getProperties());
        if (wikiImportProperty != null) {
            tagGroup.add(this.makeImportUpdateForm(wikiImportProperty));
        } else {
            tagGroup.add(this.makeImportForm());
        }
        tagGroup.add(this.makeSymbolicLinkSection());
        return tagGroup;
    }

    private HtmlTag makePropertiesForm() throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeFormTag("post", this.resource);
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "responder", "saveProperties"));
        HtmlTag htmlTag2 = new HtmlTag("div");
        htmlTag2.addAttribute("style", "height: 200px");
        htmlTag2.add(this.makeTestActionCheckboxesHtml(this.pageData));
        htmlTag2.add(this.makeNavigationCheckboxesHtml(this.pageData));
        htmlTag2.add(this.makeSecurityCheckboxesHtml(this.pageData));
        htmlTag2.add(this.makeVirtualWikiHtml());
        htmlTag.add(htmlTag2);
        HtmlTag htmlTag3 = HtmlUtil.makeInputTag("submit", "Save", "Save Properties");
        htmlTag3.addAttribute("accesskey", "s");
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(htmlTag3);
        return htmlTag;
    }

    private HtmlTag makeVirtualWikiHtml() throws Exception {
        HtmlTag htmlTag = new HtmlTag("div");
        htmlTag.addAttribute("style", "float: left;");
        htmlTag.add("VirtualWiki URL: ");
        HtmlTag htmlTag2 = new HtmlTag("span", "(DEPRECATED)");
        htmlTag2.addAttribute("style", "color: #FF0000;");
        htmlTag.add(htmlTag2);
        htmlTag.add(HtmlUtil.BR);
        HtmlTag htmlTag3 = HtmlUtil.makeInputTag("text", "VirtualWiki", PropertiesResponder.getVirtualWikiValue(this.pageData));
        htmlTag3.addAttribute("size", "40");
        htmlTag.add(htmlTag3);
        return htmlTag;
    }

    private HtmlTag makeImportForm() {
        HtmlTag htmlTag = HtmlUtil.makeFormTag("post", this.resource + "#end");
        htmlTag.add(HtmlUtil.HR);
        htmlTag.add("Wiki Import.  Supply the URL for the wiki you'd like to import.");
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add("Remote Wiki URL:");
        HtmlTag htmlTag2 = HtmlUtil.makeInputTag("text", "remoteUrl");
        htmlTag2.addAttribute("size", "40");
        htmlTag.add(htmlTag2);
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(HtmlUtil.makeInputTag("checkbox", "autoUpdate", "0"));
        htmlTag.add("- Automatically update imported content when executing tests");
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "responder", "import"));
        htmlTag.add(HtmlUtil.makeInputTag("submit", "save", "Import"));
        return htmlTag;
    }

    private HtmlTag makeImportUpdateForm(WikiImportProperty wikiImportProperty) throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeFormTag("post", this.resource + "#end");
        htmlTag.add(HtmlUtil.HR);
        htmlTag.add(new HtmlTag("strong", "Wiki Import Update"));
        htmlTag.add(HtmlUtil.BR);
        String string = "";
        htmlTag.add(HtmlUtil.makeLink(this.page.getName(), this.page.getName()));
        if (wikiImportProperty.isRoot()) {
            htmlTag.add(" imports its subpages from ");
            string = "Update Subpages";
        } else {
            htmlTag.add(" imports its content and subpages from ");
            string = "Update Content and Subpages";
        }
        htmlTag.add(HtmlUtil.makeLink(wikiImportProperty.getSourceUrl(), wikiImportProperty.getSourceUrl()));
        htmlTag.add(".");
        htmlTag.add(HtmlUtil.BR);
        HtmlTag htmlTag2 = HtmlUtil.makeInputTag("checkbox", "autoUpdate");
        if (wikiImportProperty.isAutoUpdate()) {
            htmlTag2.addAttribute("checked", "true");
        }
        htmlTag.add(htmlTag2);
        htmlTag.add("- Automatically update imported content when executing tests");
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "responder", "import"));
        htmlTag.add(HtmlUtil.makeInputTag("submit", "save", string));
        return htmlTag;
    }

    private HtmlTag makeSymbolicLinkSection() throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeFormTag("get", this.resource);
        htmlTag.add(HtmlUtil.HR);
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "responder", "symlink"));
        htmlTag.add(new HtmlTag("strong", "Symbolic Links"));
        HtmlTableListingBuilder htmlTableListingBuilder = new HtmlTableListingBuilder();
        htmlTableListingBuilder.addRow(new HtmlElement[]{new HtmlTag("strong", "Name"), new HtmlTag("strong", "Path to Page"), new HtmlTag("strong", "Action")});
        this.addSymbolicLinkRows(htmlTableListingBuilder);
        this.addFormRow(htmlTableListingBuilder);
        htmlTag.add(htmlTableListingBuilder.getTable());
        return htmlTag;
    }

    private void addFormRow(HtmlTableListingBuilder htmlTableListingBuilder) throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeInputTag("text", "linkName");
        HtmlTag htmlTag2 = HtmlUtil.makeInputTag("text", "linkPath");
        htmlTag2.addAttribute("size", "40");
        HtmlTag htmlTag3 = HtmlUtil.makeInputTag("submit", "submit", "Create Symbolic Link");
        htmlTableListingBuilder.addRow(new HtmlElement[]{htmlTag, htmlTag2, htmlTag3});
    }

    private void addSymbolicLinkRows(HtmlTableListingBuilder htmlTableListingBuilder) throws Exception {
        WikiPageProperty wikiPageProperty = this.pageData.getProperties().getProperty("SymbolicLinks");
        if (wikiPageProperty == null) {
            return;
        }
        Set set = wikiPageProperty.keySet();
        for (String string : set) {
            RawHtml rawHtml = new RawHtml(string);
            HtmlElement htmlElement = this.makeHtmlForSymbolicPath(wikiPageProperty, string);
            HtmlTag htmlTag = HtmlUtil.makeLink(this.resource + "?responder=symlink&removal=" + string, "remove");
            htmlTableListingBuilder.addRow(new HtmlElement[]{rawHtml, htmlElement, htmlTag});
        }
    }

    private HtmlElement makeHtmlForSymbolicPath(WikiPageProperty wikiPageProperty, String string) {
        String string2 = wikiPageProperty.get(string);
        WikiPagePath wikiPagePath = PathParser.parse(string2);
        if (wikiPagePath != null) {
            return HtmlUtil.makeLink(PathParser.render(wikiPagePath), PathParser.render(wikiPagePath));
        }
        return new RawHtml(string2);
    }

    public static String getVirtualWikiValue(PageData pageData) throws Exception {
        String string = pageData.getAttribute("VirtualWiki");
        if (string == null) {
            return "";
        }
        return string;
    }

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }

    public HtmlTag makeTestActionCheckboxesHtml(PageData pageData) throws Exception {
        return this.makeAttributeCheckboxesHtml("Actions:", WikiPage.ACTION_ATTRIBUTES, pageData);
    }

    public HtmlElement makeNavigationCheckboxesHtml(PageData pageData) throws Exception {
        return this.makeAttributeCheckboxesHtml("Navigation:", WikiPage.NAVIGATION_ATTRIBUTES, pageData);
    }

    public HtmlTag makeSecurityCheckboxesHtml(PageData pageData) throws Exception {
        return this.makeAttributeCheckboxesHtml("Security:", WikiPage.SECURITY_ATTRIBUTES, pageData);
    }

    private HtmlTag makeAttributeCheckboxesHtml(String string, String[] stringArray, PageData pageData) throws Exception {
        HtmlTag htmlTag = new HtmlTag("div");
        htmlTag.addAttribute("style", "float: left; width: 150px;");
        htmlTag.add(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            htmlTag.add(HtmlUtil.BR);
            htmlTag.add(this.makeAttributeCheckbox(string2, pageData));
        }
        return htmlTag;
    }
}

