/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.components.SaveRecorder;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.Utils;

public class MergeResponder
implements Responder {
    private Request request;
    private String newContent;
    private String existingContent;
    private String resource;

    public MergeResponder(Request request) {
        this.request = request;
    }

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        SimpleResponse simpleResponse = new SimpleResponse();
        this.resource = this.request.getResource();
        WikiPagePath wikiPagePath = PathParser.parse(this.resource);
        WikiPage wikiPage = fitNesseContext.root.getPageCrawler().getPage(fitNesseContext.root, wikiPagePath);
        this.existingContent = wikiPage.getData().getContent();
        this.newContent = (String)this.request.getInput("pageContent");
        simpleResponse.setContent(this.makePageHtml(fitNesseContext));
        return simpleResponse;
    }

    private String makePageHtml(FitNesseContext fitNesseContext) throws Exception {
        HtmlPage htmlPage = fitNesseContext.htmlPageFactory.newPage();
        htmlPage.title.use("Merge " + this.resource);
        htmlPage.header.use(HtmlUtil.makeBreadCrumbsWithPageType(this.resource, "Merge Changes"));
        htmlPage.main.use(this.makeRightColumn());
        return htmlPage.html();
    }

    private String makeRightColumn() throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeFormTag("post", this.resource);
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "responder", "saveData"));
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "saveId", String.valueOf(SaveRecorder.newIdNumber())));
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "ticketId", String.valueOf(SaveRecorder.newTicket())));
        HtmlTag htmlTag2 = HtmlUtil.makeDivTag("centered");
        htmlTag2.use("This page has been recently modified.  You may want to merge existing page content into your changes.");
        htmlTag.add(htmlTag2);
        htmlTag.add(this.makeMergeNewDivTag());
        htmlTag.add(this.makeMergeOldDivTag());
        htmlTag.add(this.addHiddenAttributes());
        return htmlTag.html();
    }

    private HtmlTag makeMergeOldDivTag() {
        HtmlTag htmlTag = HtmlUtil.makeDivTag("merge_old");
        htmlTag.add("Existing Content (read only)");
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(this.makeOldContentTextArea());
        return htmlTag;
    }

    private HtmlTag makeOldContentTextArea() {
        HtmlTag htmlTag = new HtmlTag("textarea");
        htmlTag.addAttribute("name", "oldContent");
        htmlTag.addAttribute("rows", "25");
        htmlTag.addAttribute("cols", "50");
        htmlTag.addAttribute("readonly", "");
        htmlTag.add(Utils.escapeText(this.existingContent));
        return htmlTag;
    }

    private HtmlTag makeMergeNewDivTag() {
        HtmlTag htmlTag = HtmlUtil.makeDivTag("merge_new");
        htmlTag.add("Your Changes");
        htmlTag.add(HtmlUtil.BR);
        htmlTag.add(this.makeContentTextArea());
        htmlTag.add(this.makeInputTagWithAccessKey());
        return htmlTag;
    }

    private HtmlTag makeInputTagWithAccessKey() {
        HtmlTag htmlTag = HtmlUtil.makeInputTag("submit", "submit", "Save");
        htmlTag.addAttribute("accesskey", "s");
        return htmlTag;
    }

    private HtmlTag makeContentTextArea() {
        HtmlTag htmlTag = new HtmlTag("textarea");
        htmlTag.addAttribute("name", "pageContent");
        htmlTag.addAttribute("rows", "25");
        htmlTag.addAttribute("cols", "50");
        htmlTag.add(this.newContent);
        return htmlTag;
    }

    private String addHiddenAttributes() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < WikiPage.NON_SECURITY_ATTRIBUTES.length; ++i) {
            String string = WikiPage.NON_SECURITY_ATTRIBUTES[i];
            if (!this.request.hasInput(string)) continue;
            stringBuffer.append("<input type=\"hidden\" name=\"" + string + "\" value=\"On\">");
        }
        return stringBuffer.toString();
    }
}

