/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.components.SaveRecorder;
import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.TagGroup;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.SecureResponder;
import fitnesse.wiki.FixtureListBuilder;
import fitnesse.wiki.MockingPageCrawler;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.Utils;
import java.util.List;

public class EditResponder
implements SecureResponder {
    public static final String CONTENT_INPUT_NAME = "pageContent";
    public static final String SAVE_ID = "saveId";
    public static final String TICKET_ID = "ticketId";
    protected String content;
    protected WikiPage page;
    protected WikiPage root;
    protected PageData pageData;
    protected Request request;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        this.initializeResponder(fitNesseContext.root, request);
        SimpleResponse simpleResponse = new SimpleResponse();
        String string = request.getResource();
        WikiPagePath wikiPagePath = PathParser.parse(string);
        PageCrawler pageCrawler = fitNesseContext.root.getPageCrawler();
        if (!pageCrawler.pageExists(this.root, wikiPagePath)) {
            pageCrawler.setDeadEndStrategy(new MockingPageCrawler());
            this.page = pageCrawler.getPage(this.root, wikiPagePath);
        } else {
            this.page = pageCrawler.getPage(this.root, wikiPagePath);
        }
        this.pageData = this.page.getData();
        this.content = this.createPageContent();
        String string2 = this.makeHtml(string, fitNesseContext);
        simpleResponse.setContent(string2);
        simpleResponse.setMaxAge(0);
        return simpleResponse;
    }

    protected void initializeResponder(WikiPage wikiPage, Request request) {
        this.root = wikiPage;
        this.request = request;
    }

    protected String createPageContent() throws Exception {
        return this.pageData.getContent();
    }

    public String makeHtml(String string, FitNesseContext fitNesseContext) throws Exception {
        HtmlPage htmlPage = fitNesseContext.htmlPageFactory.newPage();
        htmlPage.title.use("Edit " + string);
        htmlPage.body.addAttribute("onload", "document.f.pageContent.focus()");
        htmlPage.header.use(HtmlUtil.makeBreadCrumbsWithPageType(string, "Edit Page"));
        htmlPage.main.use(this.makeEditForm(string));
        return htmlPage.html();
    }

    public HtmlTag makeEditForm(String string) throws Exception {
        Object object;
        HtmlTag htmlTag = new HtmlTag("form");
        htmlTag.addAttribute("name", "f");
        htmlTag.addAttribute("action", string);
        htmlTag.addAttribute("method", "post");
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "responder", "saveData"));
        htmlTag.add(HtmlUtil.makeInputTag("hidden", SAVE_ID, String.valueOf(SaveRecorder.newIdNumber())));
        htmlTag.add(HtmlUtil.makeInputTag("hidden", TICKET_ID, String.valueOf(SaveRecorder.newTicket())));
        if (this.request.hasInput("redirectToReferer") && this.request.hasHeader("Referer")) {
            object = this.request.getHeader("Referer").toString();
            int n = ((String)object).indexOf("?");
            if (n > 0) {
                object = ((String)object).substring(0, n);
            }
            object = (String)object + "?" + this.request.getInput("redirectAction").toString();
            htmlTag.add(HtmlUtil.makeInputTag("hidden", "redirect", (String)object));
        }
        htmlTag.add(this.createTextarea());
        htmlTag.add(this.createButtons());
        object = this.makeWizardForm(string);
        TagGroup tagGroup = new TagGroup();
        tagGroup.add(htmlTag);
        tagGroup.add((HtmlElement)object);
        return tagGroup;
    }

    private HtmlTag makeWizardForm(String string) {
        HtmlTag htmlTag = new HtmlTag("form");
        htmlTag.addAttribute("name", "tableWizardForm");
        htmlTag.addAttribute("action", string);
        htmlTag.addAttribute("method", "post");
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "responder", "tableWizard"));
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "text", ""));
        htmlTag.add(HtmlUtil.makeInputTag("hidden", "fixture", ""));
        return htmlTag;
    }

    private HtmlTag createButtons() throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeDivTag("edit_buttons");
        htmlTag.add(this.makeSaveButton());
        htmlTag.add(this.makeScriptButtons());
        htmlTag.add(this.makeWizardOptions());
        return htmlTag;
    }

    private HtmlTag makeWizardOptions() throws Exception {
        HtmlTag htmlTag = new HtmlTag("select");
        htmlTag.addAttribute("name", "fixtureTable");
        htmlTag.addAttribute("onchange", "addFixture()");
        htmlTag.add(HtmlUtil.makeOptionTag("default", "- Insert Fixture Table -"));
        List list = new FixtureListBuilder().getFixtureNames(this.page);
        for (String string : list) {
            htmlTag.add(HtmlUtil.makeOptionTag(string, string));
        }
        return htmlTag;
    }

    private HtmlTag makeScriptButtons() {
        TagGroup tagGroup = new TagGroup();
        this.includeJavaScriptFile("/files/javascript/SpreadsheetTranslator.js", tagGroup);
        this.includeJavaScriptFile("/files/javascript/spreadsheetSupport.js", tagGroup);
        HtmlTag htmlTag = new HtmlTag("script");
        htmlTag.add("\nfunction addFixture()\n{\n\tdocument.tableWizardForm.text.value = document.f.pageContent.value;\n\tdocument.tableWizardForm.fixture.value = document.f.fixtureTable.options[document.f.fixtureTable.selectedIndex].value;\n\tdocument.tableWizardForm.submit();\n}");
        tagGroup.add(htmlTag);
        return tagGroup;
    }

    private void includeJavaScriptFile(String string, TagGroup tagGroup) {
        HtmlTag htmlTag = HtmlUtil.makeJavascriptLink(string);
        tagGroup.add(htmlTag);
    }

    private HtmlTag makeSaveButton() {
        HtmlTag htmlTag = HtmlUtil.makeInputTag("submit", "save", "Save");
        htmlTag.addAttribute("tabindex", "2");
        htmlTag.addAttribute("accesskey", "s");
        return htmlTag;
    }

    private HtmlTag createTextarea() {
        HtmlTag htmlTag = new HtmlTag("textarea");
        htmlTag.addAttribute("name", CONTENT_INPUT_NAME);
        htmlTag.addAttribute("rows", "25");
        htmlTag.addAttribute("cols", "70");
        htmlTag.addAttribute("tabindex", "1");
        htmlTag.add(Utils.escapeText(this.content));
        return htmlTag;
    }

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

