/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.SecureResponder;
import fitnesse.responders.WikiImportProperty;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VirtualEnabledPageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public class WikiPageResponder
implements SecureResponder {
    protected WikiPage page;
    protected PageData pageData;
    protected String pageTitle;
    protected Request request;
    protected PageCrawler crawler;

    public WikiPageResponder() {
    }

    public WikiPageResponder(WikiPage wikiPage) throws Exception {
        this.page = wikiPage;
        this.pageData = wikiPage.getData();
    }

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        String string = request.getResource();
        if ("".equals(string)) {
            string = "FrontPage";
        }
        this.loadPage(string, fitNesseContext);
        if (this.page == null) {
            return new NotFoundResponder().makeResponse(fitNesseContext, request);
        }
        this.loadPageData();
        this.pageTitle = PathParser.render(this.crawler.getFullPath(this.page));
        String string2 = this.makeHtml(fitNesseContext);
        SimpleResponse simpleResponse = new SimpleResponse();
        simpleResponse.setMaxAge(0);
        simpleResponse.setContent(string2);
        return simpleResponse;
    }

    protected void loadPageData() throws Exception {
        this.pageData = this.page.getData();
    }

    protected void loadPage(String string, FitNesseContext fitNesseContext) throws Exception {
        WikiPagePath wikiPagePath = PathParser.parse(string);
        this.crawler = fitNesseContext.root.getPageCrawler();
        this.crawler.setDeadEndStrategy(new VirtualEnabledPageCrawler());
        this.page = this.crawler.getPage(fitNesseContext.root, wikiPagePath);
    }

    public String makeHtml(FitNesseContext fitNesseContext) throws Exception {
        WikiPage wikiPage = this.pageData.getWikiPage();
        HtmlPage htmlPage = fitNesseContext.htmlPageFactory.newPage();
        WikiPagePath wikiPagePath = wikiPage.getPageCrawler().getFullPath(wikiPage);
        String string = PathParser.render(wikiPagePath);
        htmlPage.title.use(string);
        htmlPage.header.use(HtmlUtil.makeBreadCrumbsWithCurrentPageNotLinked(string));
        htmlPage.actions.use(HtmlUtil.makeActions(this.pageData));
        htmlPage.main.use(HtmlUtil.addHeaderAndFooter(wikiPage, HtmlUtil.testableHtml(this.pageData)));
        this.handleSpecialProperties(htmlPage, wikiPage);
        return htmlPage.html();
    }

    private void handleSpecialProperties(HtmlPage htmlPage, WikiPage wikiPage) throws Exception {
        WikiImportProperty.handleImportProperties(htmlPage, wikiPage, this.pageData);
    }

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

