/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureWriteOperation;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.TagGroup;
import fitnesse.http.ChunkedResponse;
import fitnesse.responders.ChunkingResponder;
import fitnesse.responders.SecureResponder;
import fitnesse.responders.WikiImportProperty;
import fitnesse.responders.WikiImporter;
import fitnesse.responders.WikiImporterClient;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.List;

public class WikiImportingResponder
extends ChunkingResponder
implements SecureResponder,
WikiImporterClient {
    private int alternation = 0;
    private boolean isUpdate;
    private boolean isNonRoot;
    public PageData data;
    private WikiImporter importer = new WikiImporter();

    public void setImporter(WikiImporter wikiImporter) {
        this.importer = wikiImporter;
    }

    protected void doSending() throws Exception {
        this.data = this.page.getData();
        HtmlPage htmlPage = this.makeHtml();
        this.response.add(htmlPage.preDivision);
        try {
            this.initializeImporter();
            this.addHeadContent();
            if (this.isNonRoot) {
                this.importer.importRemotePageContent(this.page);
            }
            this.importer.importWiki(this.page);
            this.addTailContent();
            if (!this.isUpdate) {
                WikiImportProperty wikiImportProperty = new WikiImportProperty(this.importer.remoteUrl());
                wikiImportProperty.setRoot(true);
                wikiImportProperty.setAutoUpdate(this.importer.getAutoUpdateSetting());
                wikiImportProperty.addTo(this.data.getProperties());
                this.page.commit(this.data);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.writeErrorMessage(malformedURLException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.writeErrorMessage("The remote resource, " + this.importer.remoteUrl() + ", was not found.");
        }
        catch (WikiImporter.AuthenticationRequiredException authenticationRequiredException) {
            this.writeAuthenticationForm(authenticationRequiredException.getMessage());
        }
        catch (Exception exception) {
            this.writeErrorMessage(exception);
        }
        this.response.add(htmlPage.postDivision);
        this.response.closeAll();
    }

    public void initializeImporter() throws Exception {
        String string = this.establishRemoteUrlAndUpdateStyle();
        this.importer.setWikiImporterClient(this);
        this.importer.setLocalPath(this.path);
        this.importer.parseUrl(string);
        this.setRemoteUserCredentialsOnImporter();
        this.importer.setAutoUpdateSetting(this.request.hasInput("autoUpdate"));
    }

    private void setRemoteUserCredentialsOnImporter() {
        if (this.request.hasInput("remoteUsername")) {
            this.importer.setRemoteUsername((String)this.request.getInput("remoteUsername"));
        }
        if (this.request.hasInput("remotePassword")) {
            this.importer.setRemotePassword((String)this.request.getInput("remotePassword"));
        }
    }

    private String establishRemoteUrlAndUpdateStyle() throws Exception {
        String string = (String)this.request.getInput("remoteUrl");
        WikiImportProperty wikiImportProperty = WikiImportProperty.createFrom(this.data.getProperties());
        if (wikiImportProperty != null) {
            string = wikiImportProperty.getSourceUrl();
            this.isUpdate = true;
            this.isNonRoot = !wikiImportProperty.isRoot();
        }
        return string;
    }

    private void writeErrorMessage(String string) throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeDivTag("centered");
        htmlTag.add(new HtmlTag("h2", "Import Failure"));
        htmlTag.add(string);
        this.response.add(htmlTag.html());
    }

    private void writeErrorMessage(Exception exception) throws Exception {
        this.writeErrorMessage(exception.getMessage());
        HtmlTag htmlTag = new HtmlTag("pre");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        exception.printStackTrace(printStream);
        printStream.flush();
        htmlTag.add(new String(byteArrayOutputStream.toByteArray()));
        this.response.add(htmlTag.html());
    }

    private void addHeadContent() throws Exception {
        TagGroup tagGroup = new TagGroup();
        if (this.isUpdate) {
            tagGroup.add("Updating imported wiki.");
        } else {
            tagGroup.add("Importing wiki.");
        }
        tagGroup.add(" This may take a few moments.");
        tagGroup.add(HtmlUtil.BR);
        tagGroup.add(HtmlUtil.BR);
        tagGroup.add("Destination wiki: ");
        String string = PathParser.render(this.path);
        tagGroup.add(HtmlUtil.makeLink(string, string));
        tagGroup.add(HtmlUtil.BR);
        tagGroup.add("Source wiki: ");
        String string2 = this.importer.remoteUrl();
        tagGroup.add(HtmlUtil.makeLink(string2, string2));
        tagGroup.add(HtmlUtil.BR);
        tagGroup.add(HtmlUtil.BR);
        tagGroup.add("Imported pages:");
        tagGroup.add(HtmlUtil.HR);
        this.response.add(tagGroup.html());
    }

    private void addTailContent() throws Exception {
        TagGroup tagGroup = this.makeTailHtml(this.importer);
        this.response.add(tagGroup.html());
    }

    public TagGroup makeTailHtml(WikiImporter wikiImporter) throws Exception {
        TagGroup tagGroup = new TagGroup();
        tagGroup.add("<a name=\"end\"><hr></a>");
        tagGroup.add(HtmlUtil.makeBold("Import complete. "));
        this.addUnmodifiedCount(wikiImporter, tagGroup);
        tagGroup.add(HtmlUtil.BR);
        this.addImportedPageCount(wikiImporter, tagGroup);
        this.addOrphanedPageSection(wikiImporter, tagGroup);
        this.addAutoUpdateMessage(wikiImporter, tagGroup);
        return tagGroup;
    }

    private void addAutoUpdateMessage(WikiImporter wikiImporter, TagGroup tagGroup) {
        tagGroup.add(HtmlUtil.BR);
        String string = "Automatic Update turned " + (wikiImporter.getAutoUpdateSetting() ? "ON" : "OFF");
        tagGroup.add(string);
    }

    private void addUnmodifiedCount(WikiImporter wikiImporter, TagGroup tagGroup) {
        if (wikiImporter.getUnmodifiedCount() != 0) {
            tagGroup.add(HtmlUtil.BR);
            if (wikiImporter.getUnmodifiedCount() == 1) {
                tagGroup.add("1 page was unmodified.");
            } else {
                tagGroup.add(wikiImporter.getUnmodifiedCount() + " pages were unmodified.");
            }
        }
    }

    private void addImportedPageCount(WikiImporter wikiImporter, TagGroup tagGroup) {
        if (wikiImporter.getImportCount() == 1) {
            tagGroup.add("1 page was imported.");
        } else {
            tagGroup.add(wikiImporter.getImportCount() + " pages were imported.");
        }
    }

    private void addOrphanedPageSection(WikiImporter wikiImporter, TagGroup tagGroup) {
        List<WikiPagePath> list = wikiImporter.getOrphans();
        if (list.size() > 0) {
            tagGroup.add(HtmlUtil.BR);
            if (list.size() == 1) {
                tagGroup.add("1 orphaned page was found and has been removed.");
            } else {
                tagGroup.add(list.size() + " orphaned pages were found and have been removed.");
            }
            tagGroup.add(" This may occur when a remote page is deleted, moved, or renamed.");
            tagGroup.add(HtmlUtil.BR);
            tagGroup.add(HtmlUtil.BR);
            tagGroup.add("Orphans:");
            tagGroup.add(HtmlUtil.HR);
            for (WikiPagePath wikiPagePath : list) {
                HtmlTag htmlTag = this.alternatingRow();
                htmlTag.add(PathParser.render(wikiPagePath));
                tagGroup.add(htmlTag);
            }
            tagGroup.add(HtmlUtil.HR);
        }
    }

    private HtmlPage makeHtml() throws Exception {
        HtmlPage htmlPage = this.context.htmlPageFactory.newPage();
        htmlPage = this.context.htmlPageFactory.newPage();
        String string = "Wiki Import";
        if (this.isUpdate) {
            string = string + " Update";
        }
        String string2 = PathParser.render(this.path);
        htmlPage.title.use(string + ": " + string2);
        htmlPage.header.use(HtmlUtil.makeBreadCrumbsWithPageType(string2, string));
        htmlPage.main.add("<!--BREAKPOINT-->");
        htmlPage.divide();
        return htmlPage;
    }

    protected PageCrawler getPageCrawler() {
        return this.root.getPageCrawler();
    }

    private void addRowToResponse(String string) throws Exception {
        HtmlTag htmlTag = this.alternatingRow();
        String string2 = PathParser.render(this.importer.getRelativePath());
        String string3 = PathParser.render(this.importer.getLocalPath());
        htmlTag.add(HtmlUtil.makeLink(string3, string2));
        htmlTag.add(" " + string);
        this.response.add(htmlTag.html());
    }

    private HtmlTag alternatingRow() {
        return HtmlUtil.makeDivTag("alternating_row_" + this.alternate());
    }

    private int alternate() {
        this.alternation = this.alternation % 2 + 1;
        return this.alternation;
    }

    public void setResponse(ChunkedResponse chunkedResponse) {
        this.response = chunkedResponse;
    }

    public SecureOperation getSecureOperation() {
        return new SecureWriteOperation();
    }

    private void writeAuthenticationForm(String string) throws Exception {
        HtmlTag htmlTag = HtmlUtil.makeDivTag("centered");
        htmlTag.add(new HtmlTag("h3", "The wiki at " + string + " requires authentication."));
        htmlTag.add(HtmlUtil.BR);
        HtmlTag htmlTag2 = new HtmlTag("form");
        htmlTag2.addAttribute("action", this.request.getResource());
        htmlTag2.addAttribute("method", "post");
        htmlTag2.add(HtmlUtil.makeInputTag("hidden", "responder", "import"));
        if (this.request.hasInput("remoteUrl")) {
            htmlTag2.add(HtmlUtil.makeInputTag("hidden", "remoteUrl", (String)this.request.getInput("remoteUrl")));
        }
        htmlTag2.add("remote username: ");
        htmlTag2.add(HtmlUtil.makeInputTag("text", "remoteUsername"));
        htmlTag2.add(HtmlUtil.BR);
        htmlTag2.add("remote password: ");
        htmlTag2.add(HtmlUtil.makeInputTag("password", "remotePassword"));
        htmlTag2.add(HtmlUtil.BR);
        htmlTag2.add(HtmlUtil.makeInputTag("submit", "submit", "Authenticate and Continue Import"));
        htmlTag.add(htmlTag2);
        this.response.add(htmlTag.html());
    }

    public void pageImported(WikiPage wikiPage) throws Exception {
        this.addRowToResponse("");
    }

    public void pageImportError(WikiPage wikiPage, Exception exception) throws Exception {
        this.addRowToResponse(exception.toString());
    }

    public WikiImporter getImporter() {
        return this.importer;
    }
}

