/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.components.FitNesseTraversalListener;
import fitnesse.http.RequestBuilder;
import fitnesse.http.ResponseParser;
import fitnesse.responders.WikiImportProperty;
import fitnesse.responders.WikiImporterClient;
import fitnesse.util.XmlUtil;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageXmlizer;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.XmlizerPageHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiImporter
implements XmlizerPageHandler,
FitNesseTraversalListener {
    public static String remoteUsername;
    public static String remotePassword;
    private String remoteHostname;
    private int remotePort;
    private WikiPagePath localPath;
    private WikiPagePath remotePath = new WikiPagePath();
    private WikiPagePath relativePath = new WikiPagePath();
    protected WikiImporterClient importerClient;
    protected int importCount = 0;
    protected int unmodifiedCount = 0;
    private List<WikiPagePath> orphans = new LinkedList<WikiPagePath>();
    private HashSet<WikiPagePath> pageCatalog;
    private PageCrawler crawler;
    private boolean shouldDeleteOrphans = true;
    private WikiPagePath contextPath;
    private boolean autoUpdateSetting;

    public WikiImporter() {
        this.importerClient = new NullWikiImporterClient();
        this.localPath = new WikiPagePath();
    }

    public WikiImporter(WikiImporterClient wikiImporterClient) {
        this.importerClient = wikiImporterClient;
        this.localPath = new WikiPagePath();
    }

    public void importWiki(WikiPage wikiPage) throws Exception {
        this.catalogLocalTree(wikiPage);
        Document document = this.getPageTree();
        new PageXmlizer().deXmlizeSkippingRootLevel(document, wikiPage, this);
        this.configureAutoUpdateSetting(wikiPage);
        this.filterOrphans(wikiPage);
        if (this.shouldDeleteOrphans) {
            this.removeOrphans(wikiPage);
        }
    }

    private void removeOrphans(WikiPage wikiPage) throws Exception {
        for (WikiPagePath wikiPagePath : this.orphans) {
            WikiPage wikiPage2 = this.crawler.getPage(wikiPage, wikiPagePath);
            if (wikiPage2 == null) continue;
            wikiPage2.getParent().removeChildPage(wikiPage2.getName());
        }
    }

    private void filterOrphans(WikiPage wikiPage) throws Exception {
        for (WikiPagePath wikiPagePath : this.pageCatalog) {
            WikiPage wikiPage2 = this.crawler.getPage(wikiPage, wikiPagePath);
            PageData pageData = wikiPage2.getData();
            WikiImportProperty wikiImportProperty = WikiImportProperty.createFrom(pageData.getProperties());
            if (wikiImportProperty == null || wikiImportProperty.isRoot()) continue;
            this.orphans.add(wikiPagePath);
        }
    }

    private void catalogLocalTree(WikiPage wikiPage) throws Exception {
        this.crawler = wikiPage.getPageCrawler();
        this.contextPath = this.crawler.getFullPath(wikiPage);
        this.pageCatalog = new HashSet();
        wikiPage.getPageCrawler().traverse(wikiPage, this);
        WikiPagePath wikiPagePath = this.contextPath.subtract(this.contextPath);
        this.pageCatalog.remove(wikiPagePath);
    }

    @Override
    public void enterChildPage(WikiPage wikiPage, Date date) throws Exception {
        if (this.pageCatalog != null) {
            this.pageCatalog.remove(this.relativePath(wikiPage));
        }
        this.remotePath.addName(wikiPage.getName());
        this.relativePath.addName(wikiPage.getName());
        this.localPath.addName(wikiPage.getName());
        PageData pageData = wikiPage.getData();
        WikiPageProperties wikiPageProperties = pageData.getProperties();
        WikiImportProperty wikiImportProperty = WikiImportProperty.createFrom(wikiPageProperties);
        if (wikiImportProperty != null) {
            Date date2 = wikiImportProperty.getLastRemoteModificationTime();
            if (date.after(date2)) {
                this.importRemotePageContent(wikiPage);
            } else {
                ++this.unmodifiedCount;
                this.configureAutoUpdateSetting(wikiImportProperty, pageData, wikiPage);
            }
        } else {
            this.importRemotePageContent(wikiPage);
        }
    }

    private void configureAutoUpdateSetting(WikiImportProperty wikiImportProperty, PageData pageData, WikiPage wikiPage) throws Exception {
        if (wikiImportProperty.isAutoUpdate() != this.autoUpdateSetting) {
            wikiImportProperty.setAutoUpdate(this.autoUpdateSetting);
            wikiImportProperty.addTo(pageData.getProperties());
            wikiPage.commit(pageData);
        }
    }

    public void configureAutoUpdateSetting(WikiPage wikiPage) throws Exception {
        PageData pageData = wikiPage.getData();
        WikiPageProperties wikiPageProperties = pageData.getProperties();
        WikiImportProperty wikiImportProperty = WikiImportProperty.createFrom(wikiPageProperties);
        if (wikiImportProperty != null) {
            this.configureAutoUpdateSetting(wikiImportProperty, pageData, wikiPage);
        }
    }

    private WikiPagePath relativePath(WikiPage wikiPage) throws Exception {
        return this.crawler.getFullPath(wikiPage).subtract(this.contextPath);
    }

    protected void importRemotePageContent(WikiPage wikiPage) throws Exception {
        try {
            Document document = this.getXmlDocument("data");
            PageData pageData = new PageXmlizer().deXmlizeData(document);
            WikiPageProperties wikiPageProperties = pageData.getProperties();
            wikiPageProperties.remove("Edit");
            WikiImportProperty wikiImportProperty = new WikiImportProperty(this.remoteUrl());
            Date date = wikiPageProperties.getLastModificationTime();
            wikiImportProperty.setLastRemoteModificationTime(date);
            wikiImportProperty.setAutoUpdate(this.autoUpdateSetting);
            wikiImportProperty.addTo(wikiPageProperties);
            wikiPage.commit(pageData);
            this.importerClient.pageImported(wikiPage);
        }
        catch (AuthenticationRequiredException authenticationRequiredException) {
            throw authenticationRequiredException;
        }
        catch (Exception exception) {
            this.importerClient.pageImportError(wikiPage, exception);
        }
        ++this.importCount;
    }

    public String remoteUrl() {
        String string = PathParser.render(this.remotePath);
        return "http://" + this.remoteHostname + ":" + this.remotePort + "/" + string;
    }

    @Override
    public void exitPage() {
        this.remotePath.pop();
        this.relativePath.pop();
        this.localPath.pop();
    }

    public Document getPageTree() throws Exception {
        return this.getXmlDocument("pages");
    }

    private Document getXmlDocument(String string) throws Exception {
        ResponseParser responseParser;
        String string2 = PathParser.render(this.remotePath);
        RequestBuilder requestBuilder = new RequestBuilder("/" + string2);
        requestBuilder.addInput("responder", "proxy");
        requestBuilder.addInput("type", string);
        requestBuilder.setHostAndPort(this.remoteHostname, this.remotePort);
        if (remoteUsername != null) {
            requestBuilder.addCredentials(remoteUsername, remotePassword);
        }
        if ((responseParser = ResponseParser.performHttpRequest(this.remoteHostname, this.remotePort, requestBuilder)).getStatus() == 404) {
            throw new Exception("The remote resource, " + this.remoteUrl() + ", was not found.");
        }
        if (responseParser.getStatus() == 401) {
            throw new AuthenticationRequiredException(this.remoteUrl());
        }
        String string3 = responseParser.getBody();
        return XmlUtil.newDocument(string3);
    }

    public void setRemoteUsername(String string) {
        remoteUsername = string;
    }

    public void setRemotePassword(String string) {
        remotePassword = string;
    }

    public WikiPagePath getRelativePath() {
        return this.relativePath;
    }

    public WikiPagePath getLocalPath() {
        return this.localPath;
    }

    public String getRemoteHostname() {
        return this.remoteHostname;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public WikiPagePath getRemotePath() {
        return this.remotePath;
    }

    public int getUnmodifiedCount() {
        return this.unmodifiedCount;
    }

    public int getImportCount() {
        return this.importCount;
    }

    public void parseUrl(String string) throws Exception {
        String string2;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new MalformedURLException(string + " is not a valid URL.");
        }
        this.remoteHostname = uRL.getHost();
        this.remotePort = uRL.getPort();
        if (this.remotePort == -1) {
            this.remotePort = 80;
        }
        if ((string2 = uRL.getPath()).startsWith("/")) {
            string2 = string2.substring(1);
        }
        this.remotePath = PathParser.parse(string2);
        if (this.remotePath == null) {
            throw new MalformedURLException("The URL's resource path, " + string2 + ", is not a valid WikiWord.");
        }
    }

    public void setWikiImporterClient(WikiImporterClient wikiImporterClient) {
        this.importerClient = wikiImporterClient;
    }

    public void setLocalPath(WikiPagePath wikiPagePath) {
        this.localPath = wikiPagePath;
    }

    public List<WikiPagePath> getOrphans() {
        return this.orphans;
    }

    @Override
    public void processPage(WikiPage wikiPage) throws Exception {
        WikiPagePath wikiPagePath = this.relativePath(wikiPage);
        this.pageCatalog.add(wikiPagePath);
    }

    @Override
    public String getSearchPattern() throws Exception {
        return null;
    }

    public void setDeleteOrphanOption(boolean bl) {
        this.shouldDeleteOrphans = bl;
    }

    public boolean getAutoUpdateSetting() {
        return this.autoUpdateSetting;
    }

    public void setAutoUpdateSetting(boolean bl) {
        this.autoUpdateSetting = bl;
    }

    public static class AuthenticationRequiredException
    extends Exception {
        public AuthenticationRequiredException(String string) {
            super(string);
        }
    }

    private static class NullWikiImporterClient
    implements WikiImporterClient {
        private NullWikiImporterClient() {
        }

        public void pageImported(WikiPage wikiPage) {
        }

        public void pageImportError(WikiPage wikiPage, Exception exception) {
        }
    }
}

