/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.responders.WikiImportProperty;
import fitnesse.responders.WikiImporter;
import fitnesse.responders.WikiImporterClient;
import fitnesse.responders.WikiImporterFactory;
import fitnesse.responders.run.SuiteResponder;
import fitnesse.responders.run.TestEventListener;
import fitnesse.responders.run.TestResponder;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;

public class WikiImportTestEventListener
implements TestEventListener {
    private WikiImporterFactory importerFactory;

    public static void register() {
        TestResponder.registerListener(new WikiImportTestEventListener(new WikiImporterFactory()));
    }

    public WikiImportTestEventListener(WikiImporterFactory wikiImporterFactory) {
        this.importerFactory = wikiImporterFactory;
    }

    public void notifyPreTest(TestResponder testResponder, PageData pageData) throws Exception {
        TestEventProcessor testEventProcessor = testResponder instanceof SuiteResponder ? new SuiteEventProcessor() : new TestEventProcessor();
        testEventProcessor.run(testResponder, pageData);
    }

    private class SuiteEventProcessor
    extends TestEventProcessor {
        private SuiteEventProcessor() {
        }

        protected void doUpdating() throws Exception {
            if (!this.importProperty.isRoot()) {
                this.updatePagePassedIn();
            }
            this.wikiImporter.importWiki(this.wikiPage);
        }
    }

    private class TestEventProcessor
    implements WikiImporterClient {
        private TestResponder testResponder;
        private boolean errorOccured;
        protected WikiImporter wikiImporter;
        protected WikiPage wikiPage;
        protected PageData data;
        protected WikiImportProperty importProperty;

        private TestEventProcessor() {
        }

        public void run(TestResponder testResponder, PageData pageData) throws Exception {
            this.testResponder = testResponder;
            this.data = pageData;
            this.importProperty = WikiImportProperty.createFrom(pageData.getProperties());
            if (this.importProperty != null && this.importProperty.isAutoUpdate()) {
                testResponder.addToResponse("<span class=\"meta\">Updating imported content...</span>");
                testResponder.addToResponse("<span class=\"meta\">");
                try {
                    this.wikiImporter = WikiImportTestEventListener.this.importerFactory.newImporter(this);
                    this.wikiImporter.parseUrl(this.importProperty.getSourceUrl());
                    this.wikiPage = pageData.getWikiPage();
                    this.doUpdating();
                    if (!this.errorOccured) {
                        testResponder.addToResponse("done");
                    }
                }
                catch (Exception exception) {
                    this.pageImportError(pageData.getWikiPage(), exception);
                }
                testResponder.addToResponse("</span>");
            }
        }

        protected void doUpdating() throws Exception {
            this.updatePagePassedIn();
        }

        protected void updatePagePassedIn() throws Exception {
            this.wikiImporter.importRemotePageContent(this.wikiPage);
            this.data.setContent(this.wikiPage.getData().getContent());
        }

        public void pageImported(WikiPage wikiPage) throws Exception {
        }

        public void pageImportError(WikiPage wikiPage, Exception exception) throws Exception {
            this.errorOccured = true;
            this.testResponder.addToResponse(exception.toString());
        }
    }
}

