/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlUtil;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperty;
import java.util.Date;

public class WikiImportProperty
extends WikiPageProperty {
    public static final String PROPERTY_NAME = "WikiImport";

    private WikiImportProperty() {
    }

    public WikiImportProperty(String string) {
        this.set("Source", string);
    }

    public String getSourceUrl() {
        return this.get("Source");
    }

    public boolean isRoot() {
        return this.has("IsRoot");
    }

    public void setRoot(boolean bl) {
        if (bl) {
            this.set("IsRoot");
        } else {
            this.remove("IsRoot");
        }
    }

    public boolean isAutoUpdate() {
        return this.has("AutoUpdate");
    }

    public void setAutoUpdate(boolean bl) {
        if (bl) {
            this.set("AutoUpdate");
        } else {
            this.remove("AutoUpdate");
        }
    }

    public static WikiImportProperty createFrom(WikiPageProperty wikiPageProperty) {
        if (wikiPageProperty.has(PROPERTY_NAME)) {
            WikiImportProperty wikiImportProperty = new WikiImportProperty();
            WikiPageProperty wikiPageProperty2 = wikiPageProperty.getProperty(PROPERTY_NAME);
            wikiImportProperty.set("Source", wikiPageProperty2.getProperty("Source"));
            wikiImportProperty.set("LastRemoteModification", wikiPageProperty2.getProperty("LastRemoteModification"));
            if (wikiPageProperty2.has("IsRoot")) {
                wikiImportProperty.set("IsRoot", wikiPageProperty2.getProperty("IsRoot"));
            }
            if (wikiPageProperty2.has("AutoUpdate")) {
                wikiImportProperty.set("AutoUpdate", wikiPageProperty2.getProperty("AutoUpdate"));
            }
            return wikiImportProperty;
        }
        return null;
    }

    public void addTo(WikiPageProperty wikiPageProperty) {
        wikiPageProperty.set(PROPERTY_NAME, this);
    }

    public void setLastRemoteModificationTime(Date date) {
        this.set("LastRemoteModification", WikiImportProperty.getTimeFormat().format(date));
    }

    public Date getLastRemoteModificationTime() throws Exception {
        Date date = new Date(0L);
        String string = this.get("LastRemoteModification");
        if (string != null) {
            date = WikiImportProperty.getTimeFormat().parse(string);
        }
        return date;
    }

    public static void handleImportProperties(HtmlPage htmlPage, WikiPage wikiPage, PageData pageData) throws Exception {
        htmlPage.actions.add(HtmlUtil.makeNavBreak());
        WikiImportProperty wikiImportProperty = WikiImportProperty.createFrom(pageData.getProperties());
        if (wikiImportProperty != null && !wikiImportProperty.isRoot()) {
            htmlPage.body.addAttribute("class", "imported");
            WikiPagePath wikiPagePath = wikiPage.getPageCrawler().getFullPath(wikiPage);
            String string = PathParser.render(wikiPagePath);
            htmlPage.actions.add(HtmlUtil.makeActionLink(string, "Edit Locally", "edit", "e", false));
            String string2 = "responder=edit&redirectToReferer=true&redirectAction=importAndView";
            htmlPage.actions.add(HtmlUtil.makeActionLink(wikiImportProperty.getSourceUrl(), "Edit Remotely", string2, "e", false));
        } else if (wikiPage instanceof ProxyPage) {
            htmlPage.body.addAttribute("class", "virtual");
        }
    }
}

