/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.TagGroup;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;

public class UnauthorizedResponder
implements Responder {
    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        SimpleResponse simpleResponse = new SimpleResponse(401);
        simpleResponse.addHeader("WWW-Authenticate", "Basic realm=\"FitNesse\"");
        HtmlPage htmlPage = fitNesseContext.htmlPageFactory.newPage();
        HtmlUtil.addTitles(htmlPage, "401 Unauthorized");
        htmlPage.main.use(this.makeContent(request));
        simpleResponse.setContent(htmlPage.html());
        return simpleResponse;
    }

    private HtmlTag makeContent(Request request) throws Exception {
        TagGroup tagGroup = new TagGroup();
        tagGroup.add(this.makeSimpleTag("h1", "Unauthorized"));
        tagGroup.add("<p>The requested resource: ");
        tagGroup.add(this.makeSimpleTag("b", request.getResource()));
        tagGroup.add(" is restricted.");
        tagGroup.add("<p> Either your credientials were not supplied or they didn't match the criteria to access this resource.");
        tagGroup.add(HtmlUtil.HR);
        tagGroup.add(this.makeSimpleTag("address", "FitNesse"));
        return tagGroup;
    }

    private String makeSimpleTag(String string, String string2) throws Exception {
        HtmlTag htmlTag = new HtmlTag(string);
        htmlTag.add(string2);
        return htmlTag.html();
    }
}

