/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.components.XmlWriter;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.SecureResponder;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageXmlizer;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.XmlizePageCondition;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.w3c.dom.Document;

public class SerializedPageResponder
implements SecureResponder {
    private XmlizePageCondition xmlizePageCondition = new XmlizePageCondition(){

        public boolean canBeXmlized(WikiPage wikiPage) throws Exception {
            return !(wikiPage instanceof SymbolicPage);
        }
    };

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        WikiPage wikiPage = this.getRequestedPage(request, fitNesseContext);
        if (wikiPage == null) {
            return new NotFoundResponder().makeResponse(fitNesseContext, request);
        }
        if ("pages".equals(request.getInput("type"))) {
            PageXmlizer pageXmlizer = new PageXmlizer();
            pageXmlizer.addPageCondition(this.xmlizePageCondition);
            Document document = pageXmlizer.xmlize(wikiPage);
            SimpleResponse simpleResponse = this.makeResponseWithxml(document);
            return simpleResponse;
        }
        if ("data".equals(request.getInput("type"))) {
            Document document = new PageXmlizer().xmlize(wikiPage.getData());
            SimpleResponse simpleResponse = this.makeResponseWithxml(document);
            return simpleResponse;
        }
        Object object = this.getObjectToSerialize(request, wikiPage);
        byte[] byArray = this.serializeToBytes(object);
        return this.responseWith(byArray);
    }

    private SimpleResponse makeResponseWithxml(Document document) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlWriter xmlWriter = new XmlWriter(byteArrayOutputStream);
        xmlWriter.write(document);
        xmlWriter.flush();
        xmlWriter.close();
        SimpleResponse simpleResponse = new SimpleResponse();
        simpleResponse.setContentType("text/xml");
        simpleResponse.setContent(byteArrayOutputStream.toByteArray());
        return simpleResponse;
    }

    private Object getObjectToSerialize(Request request, WikiPage wikiPage) throws Exception {
        Serializable serializable;
        if ("bones".equals(request.getInput("type"))) {
            serializable = new ProxyPage(wikiPage);
        } else if ("meat".equals(request.getInput("type"))) {
            PageData pageData = wikiPage.getData();
            if (request.hasInput("version")) {
                pageData = wikiPage.getDataVersion((String)request.getInput("version"));
            }
            PageData pageData2 = new PageData(pageData);
            serializable = pageData2;
        } else {
            throw new Exception("Improper use of proxy retrieval");
        }
        return serializable;
    }

    private WikiPage getRequestedPage(Request request, FitNesseContext fitNesseContext) throws Exception {
        String string = request.getResource();
        WikiPagePath wikiPagePath = PathParser.parse(string);
        WikiPage wikiPage = fitNesseContext.root.getPageCrawler().getPage(fitNesseContext.root, wikiPagePath);
        return wikiPage;
    }

    private SimpleResponse responseWith(byte[] byArray) {
        SimpleResponse simpleResponse = new SimpleResponse();
        simpleResponse.setContentType("application/octet-stream");
        simpleResponse.setContent(byArray);
        return simpleResponse;
    }

    private byte[] serializeToBytes(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

