/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.components.XmlWriter;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.util.XmlUtil;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.io.ByteArrayOutputStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RssResponder
implements Responder {
    protected Element channelElement;
    private String resource;
    private WikiPage contextPage;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        Document document = this.buildRssHeader();
        this.resource = request.getResource();
        this.contextPage = fitNesseContext.root.getPageCrawler().getPage(fitNesseContext.root, PathParser.parse(this.resource));
        XmlUtil.addTextNode(document, this.channelElement, "title", "FitNesse:");
        WikiPage wikiPage = fitNesseContext.root.getChildPage("RecentChanges");
        this.buildItemReport(wikiPage, document, request.getResource());
        SimpleResponse simpleResponse = this.responseFrom(document);
        return simpleResponse;
    }

    protected void buildItemReport(WikiPage wikiPage, Document document, String string) throws Exception {
        if (wikiPage != null) {
            String[] stringArray = this.getLines(wikiPage);
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("\\|");
                String string2 = stringArray2[1];
                String string3 = stringArray2[2];
                String string4 = stringArray2[3];
                string4 = this.convertDateFormat(string4);
                if (!this.shouldReportItem(string, string2)) continue;
                this.buildItem(document, string2, string3, string4);
            }
        }
    }

    protected String[] getLines(WikiPage wikiPage) throws Exception {
        PageData pageData = wikiPage.getData();
        String string = pageData.getContent();
        String[] stringArray = string.split("\n");
        return stringArray;
    }

    protected boolean shouldReportItem(String string, String string2) {
        return !this.exists(string) || string2.startsWith(string);
    }

    private void buildItem(Document document, String string, String string2, String string3) throws Exception {
        Element element = document.createElement("item");
        this.makeNodes(document, element, string, string2, string3);
        this.buildLink(document, element, string);
        String string4 = this.makeDescription(string2, string3);
        XmlUtil.addTextNode(document, element, "description", string4);
        Element element2 = element;
        this.channelElement.appendChild(element2);
    }

    protected void makeNodes(Document document, Element element, String string, String string2, String string3) {
        XmlUtil.addTextNode(document, element, "title", string);
        XmlUtil.addTextNode(document, element, "author", string2);
        XmlUtil.addTextNode(document, element, "pubDate", string3);
    }

    protected void buildLink(Document document, Element element, String string) throws Exception {
        Object object;
        String string2 = "http://localhost/";
        if (this.contextPage != null) {
            object = this.contextPage.getData();
            String string3 = ((PageData)object).getVariable("RSS_PREFIX");
            string2 = string3 == null ? string2 : string3;
        }
        object = string2 + string;
        XmlUtil.addTextNode(document, element, "link", (String)object);
    }

    protected String makeDescription(String string, String string2) {
        String string3 = "";
        if (this.exists(string)) {
            string3 = string + ":";
        }
        String string4 = string3 + string2;
        return string4;
    }

    protected boolean exists(String string) {
        return string != null && string.length() > 0;
    }

    private SimpleResponse responseFrom(Document document) throws Exception {
        byte[] byArray = this.toByteArray(document);
        SimpleResponse simpleResponse = new SimpleResponse();
        simpleResponse.setContent(byArray);
        simpleResponse.setContentType("text/xml");
        return simpleResponse;
    }

    private byte[] toByteArray(Document document) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlWriter xmlWriter = new XmlWriter(byteArrayOutputStream);
        xmlWriter.write(document);
        xmlWriter.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    private Document buildRssHeader() throws Exception {
        Document document = XmlUtil.newDocument();
        Element element = document.createElement("rss");
        document.appendChild(element);
        this.channelElement = document.createElement("channel");
        element.setAttribute("version", "2.0");
        element.appendChild(this.channelElement);
        return document;
    }

    protected String convertDateFormat(String string) {
        Pattern pattern = Pattern.compile("\\d*:\\d*:\\d* \\w*, \\w* \\d*, \\d*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return new SimpleDateFormat(FitNesseContext.rfcCompliantDateFormat).format(new SimpleDateFormat(FitNesseContext.recentChangesDateFormat).parse(string, new ParsePosition(0)));
        }
        return string;
    }
}

