/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.Responder;
import fitnesse.http.Request;
import fitnesse.responders.DefaultResponder;
import fitnesse.responders.ImportAndViewResponder;
import fitnesse.responders.NameWikiPageResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.PageDataWikiPageResponder;
import fitnesse.responders.RawContentResponder;
import fitnesse.responders.RssResponder;
import fitnesse.responders.SerializedPageResponder;
import fitnesse.responders.ShutdownResponder;
import fitnesse.responders.WikiImportingResponder;
import fitnesse.responders.WikiPageResponder;
import fitnesse.responders.editing.EditResponder;
import fitnesse.responders.editing.PropertiesResponder;
import fitnesse.responders.editing.SavePropertiesResponder;
import fitnesse.responders.editing.SaveResponder;
import fitnesse.responders.editing.SymbolicLinkResponder;
import fitnesse.responders.editing.TableWizardResponder;
import fitnesse.responders.files.CreateDirectoryResponder;
import fitnesse.responders.files.DeleteConfirmationResponder;
import fitnesse.responders.files.DeleteFileResponder;
import fitnesse.responders.files.FileResponder;
import fitnesse.responders.files.RenameFileConfirmationResponder;
import fitnesse.responders.files.RenameFileResponder;
import fitnesse.responders.files.UploadResponder;
import fitnesse.responders.refactoring.DeletePageResponder;
import fitnesse.responders.refactoring.MovePageResponder;
import fitnesse.responders.refactoring.RefactorPageResponder;
import fitnesse.responders.refactoring.RenamePageResponder;
import fitnesse.responders.run.FitClientResponder;
import fitnesse.responders.run.SocketCatchingResponder;
import fitnesse.responders.run.SuiteResponder;
import fitnesse.responders.run.TestResponder;
import fitnesse.responders.run.TestResultFormattingResponder;
import fitnesse.responders.search.SearchFormResponder;
import fitnesse.responders.search.SearchResponder;
import fitnesse.responders.search.WhereUsedResponder;
import fitnesse.responders.versions.RollbackResponder;
import fitnesse.responders.versions.VersionResponder;
import fitnesse.responders.versions.VersionSelectionResponder;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.widgets.WikiWordWidget;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class ResponderFactory {
    private String rootPath;
    private Map responderMap;

    public ResponderFactory(String string) {
        this.rootPath = string;
        this.responderMap = new HashMap();
        this.addResponder("edit", EditResponder.class);
        this.addResponder("saveData", SaveResponder.class);
        this.addResponder("tableWizard", TableWizardResponder.class);
        this.addResponder("search", SearchResponder.class);
        this.addResponder("searchForm", SearchFormResponder.class);
        this.addResponder("test", TestResponder.class);
        this.addResponder("suite", SuiteResponder.class);
        this.addResponder("proxy", SerializedPageResponder.class);
        this.addResponder("versions", VersionSelectionResponder.class);
        this.addResponder("viewVersion", VersionResponder.class);
        this.addResponder("rollback", RollbackResponder.class);
        this.addResponder("names", NameWikiPageResponder.class);
        this.addResponder("properties", PropertiesResponder.class);
        this.addResponder("saveProperties", SavePropertiesResponder.class);
        this.addResponder("whereUsed", WhereUsedResponder.class);
        this.addResponder("refactor", RefactorPageResponder.class);
        this.addResponder("deletePage", DeletePageResponder.class);
        this.addResponder("renamePage", RenamePageResponder.class);
        this.addResponder("movePage", MovePageResponder.class);
        this.addResponder("pageData", PageDataWikiPageResponder.class);
        this.addResponder("createDir", CreateDirectoryResponder.class);
        this.addResponder("upload", UploadResponder.class);
        this.addResponder("socketCatcher", SocketCatchingResponder.class);
        this.addResponder("fitClient", FitClientResponder.class);
        this.addResponder("deleteFile", DeleteFileResponder.class);
        this.addResponder("renameFile", RenameFileResponder.class);
        this.addResponder("deleteConfirmation", DeleteConfirmationResponder.class);
        this.addResponder("renameConfirmation", RenameFileConfirmationResponder.class);
        this.addResponder("raw", RawContentResponder.class);
        this.addResponder("rss", RssResponder.class);
        this.addResponder("import", WikiImportingResponder.class);
        this.addResponder("files", FileResponder.class);
        this.addResponder("shutdown", ShutdownResponder.class);
        this.addResponder("format", TestResultFormattingResponder.class);
        this.addResponder("symlink", SymbolicLinkResponder.class);
        this.addResponder("importAndView", ImportAndViewResponder.class);
    }

    public void addResponder(String string, Class clazz) {
        this.responderMap.put(string, clazz);
    }

    public String getResponderKey(Request request) {
        if (request.hasInput("responder")) {
            return (String)request.getInput("responder");
        }
        return request.getQueryString();
    }

    public Responder makeResponder(Request request, WikiPage wikiPage) throws Exception {
        String string;
        Responder responder = new DefaultResponder();
        String string2 = request.getResource();
        if ("".equals(string2)) {
            string2 = "FrontPage";
        }
        responder = this.usingResponderKey(string = this.getResponderKey(request)) ? this.lookupResponder(string, responder) : (string2.startsWith("files/") || string2.equals("files") ? FileResponder.makeResponder(request, this.rootPath) : (WikiWordWidget.isWikiWord(string2) || "root".equals(string2) ? new WikiPageResponder() : new NotFoundResponder()));
        return responder;
    }

    private Responder lookupResponder(String string, Responder responder) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class clazz = this.getResponderClass(string);
        if (clazz != null) {
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                responder = (Responder)constructor.newInstance(this.rootPath);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Constructor constructor = clazz.getConstructor(new Class[0]);
                responder = (Responder)constructor.newInstance(new Object[0]);
            }
        }
        return responder;
    }

    public Class getResponderClass(String string) {
        return (Class)this.responderMap.get(string);
    }

    private boolean usingResponderKey(String string) {
        return !"".equals(string) && string != null;
    }
}

