/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import java.util.regex.Pattern;

public class NotFoundResponder
implements Responder {
    private String resource;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        SimpleResponse simpleResponse = new SimpleResponse(404);
        this.resource = request.getResource();
        simpleResponse.setContent(this.makeHtml(fitNesseContext));
        return simpleResponse;
    }

    private String makeHtml(FitNesseContext fitNesseContext) throws Exception {
        HtmlPage htmlPage = fitNesseContext.htmlPageFactory.newPage();
        HtmlUtil.addTitles(htmlPage, "Not Found:" + this.resource);
        htmlPage.main.use(this.makeRightColumn(this.resource));
        return htmlPage.html();
    }

    private String makeRightColumn(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("The requested resource: <i>" + string + "</i> was not found.");
        if (Pattern.matches("(?:\\^|\\./|(?:\\.\\./)+)?(?:[./]?\\b[A-Z](?:[a-z0-9]+[A-Z][a-z0-9]*)+)+\\b", string)) {
            HtmlTag htmlTag = new HtmlTag("ul");
            HtmlTag htmlTag2 = new HtmlTag("li");
            htmlTag2.add(HtmlUtil.makeLink(string + "?edit", "create this page"));
            htmlTag.add(htmlTag2);
            stringBuffer.append(htmlTag.html());
        }
        return stringBuffer.toString();
    }
}

