/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.responders.WikiImporter;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import java.util.Iterator;

public class MockWikiImporter
extends WikiImporter {
    public static String mockContent = "mock importer content";
    public boolean fail;

    protected void importRemotePageContent(WikiPage wikiPage) throws Exception {
        if (this.fail) {
            this.importerClient.pageImportError(wikiPage, new Exception("blah"));
        } else {
            this.setMockContent(wikiPage);
        }
    }

    private void setMockContent(WikiPage wikiPage) throws Exception {
        PageData pageData = wikiPage.getData();
        pageData.setContent(mockContent);
        wikiPage.commit(pageData);
    }

    public void importWiki(WikiPage wikiPage) throws Exception {
        PageCrawler pageCrawler = wikiPage.getPageCrawler();
        Iterator<WikiPage> iterator = wikiPage.getChildren().iterator();
        while (iterator.hasNext()) {
            pageCrawler.traverse(iterator.next(), this);
        }
    }

    public void processPage(WikiPage wikiPage) throws Exception {
        this.setMockContent(wikiPage);
    }
}

