/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.NotFoundResponder;
import fitnesse.responders.WikiImportProperty;
import fitnesse.responders.WikiImporter;
import fitnesse.responders.WikiImporterClient;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VirtualEnabledPageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public class ImportAndViewResponder
implements Responder,
WikiImporterClient {
    private WikiPage page;

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        String string = request.getResource();
        if ("".equals(string)) {
            string = "FrontPage";
        }
        this.loadPage(string, fitNesseContext);
        if (this.page == null) {
            return new NotFoundResponder().makeResponse(fitNesseContext, request);
        }
        this.loadPageData();
        SimpleResponse simpleResponse = new SimpleResponse();
        simpleResponse.redirect(string);
        return simpleResponse;
    }

    protected void loadPage(String string, FitNesseContext fitNesseContext) throws Exception {
        WikiPagePath wikiPagePath = PathParser.parse(string);
        PageCrawler pageCrawler = fitNesseContext.root.getPageCrawler();
        pageCrawler.setDeadEndStrategy(new VirtualEnabledPageCrawler());
        this.page = pageCrawler.getPage(fitNesseContext.root, wikiPagePath);
    }

    protected void loadPageData() throws Exception {
        PageData pageData = this.page.getData();
        WikiImportProperty wikiImportProperty = WikiImportProperty.createFrom(pageData.getProperties());
        if (wikiImportProperty != null) {
            WikiImporter wikiImporter = new WikiImporter();
            wikiImporter.setWikiImporterClient(this);
            wikiImporter.parseUrl(wikiImportProperty.getSourceUrl());
            wikiImporter.importRemotePageContent(this.page);
        }
    }

    public void pageImported(WikiPage wikiPage) throws Exception {
    }

    public void pageImportError(WikiPage wikiPage, Exception exception) throws Exception {
        exception.printStackTrace();
    }
}

