/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;

public class ErrorResponder
implements Responder {
    Exception exception;
    private String message;

    public ErrorResponder(Exception exception) {
        this.exception = exception;
    }

    public ErrorResponder(String string) {
        this.message = string;
    }

    public Response makeResponse(FitNesseContext fitNesseContext, Request request) throws Exception {
        SimpleResponse simpleResponse = new SimpleResponse(400);
        HtmlPage htmlPage = fitNesseContext.htmlPageFactory.newPage();
        HtmlUtil.addTitles(htmlPage, "Error Occured");
        if (this.exception != null) {
            htmlPage.main.add("<pre>" + ErrorResponder.makeExceptionString(this.exception) + "</pre>");
        }
        if (this.message != null) {
            htmlPage.main.add(this.makeErrorMessage());
        }
        simpleResponse.setContent(htmlPage.html());
        return simpleResponse;
    }

    public static String makeExceptionString(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(exception.toString()).append("\n");
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuffer.append("\t" + stackTraceElementArray[i]).append("\n");
        }
        return stringBuffer.toString();
    }

    public HtmlTag makeErrorMessage() {
        HtmlTag htmlTag = HtmlUtil.makeDivTag("centered");
        htmlTag.add(this.message);
        return htmlTag;
    }
}

