/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import java.nio.ByteBuffer;

public class SimpleResponse
extends Response {
    private byte[] content = new byte[0];

    public SimpleResponse() {
    }

    public SimpleResponse(int n) {
        super(n);
    }

    public void readyToSend(ResponseSender responseSender) throws Exception {
        byte[] byArray = this.getBytes();
        responseSender.send(byArray);
        responseSender.close();
    }

    public void setContent(String string) throws Exception {
        this.content = this.getEncodedBytes(string);
    }

    public void setContent(byte[] byArray) {
        this.content = byArray;
    }

    public String getContent() {
        return new String(this.content);
    }

    public byte[] getContentBytes() {
        return this.content;
    }

    public String getText() {
        return new String(this.getBytes());
    }

    public byte[] getBytes() {
        this.addStandardHeaders();
        byte[] byArray = this.makeHttpHeaders().getBytes();
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length + this.getContentSize());
        byteBuffer.put(byArray).put(this.content);
        return byteBuffer.array();
    }

    public int getContentSize() {
        return this.content.length;
    }

    protected void addSpecificHeaders() {
        this.addHeader("Content-Length", String.valueOf(this.getContentSize()));
    }
}

