/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.RequestBuilder;
import fitnesse.util.StreamReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResponseParser {
    private int status;
    private String body;
    private HashMap headers = new HashMap();
    private StreamReader input;
    private static final Pattern statusLinePattern = Pattern.compile("HTTP/\\d.\\d (\\d\\d\\d) ");
    private static final Pattern headerPattern = Pattern.compile("([^:]*): (.*)");

    public ResponseParser(InputStream inputStream) throws Exception {
        this.input = new StreamReader(inputStream);
        this.parseStatusLine();
        this.parseHeaders();
        if (this.isChuncked()) {
            this.parseChunks();
            this.parseHeaders();
        } else {
            this.parseBody();
        }
    }

    private boolean isChuncked() {
        String string = this.getHeader("Transfer-Encoding");
        return string != null && "chunked".equals(string.toLowerCase());
    }

    private void parseStatusLine() throws Exception {
        String string = this.input.readLine();
        Matcher matcher = statusLinePattern.matcher(string);
        if (!matcher.find()) {
            throw new Exception("Could not parse Response");
        }
        String string2 = matcher.group(1);
        this.status = Integer.parseInt(string2);
    }

    private void parseHeaders() throws Exception {
        String string = this.input.readLine();
        while (!"".equals(string)) {
            Matcher matcher = headerPattern.matcher(string);
            if (matcher.find()) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                this.headers.put(string2, string3);
            }
            string = this.input.readLine();
        }
    }

    private void parseBody() throws Exception {
        String string = "Content-Length";
        if (this.hasHeader(string)) {
            int n = Integer.parseInt(this.getHeader(string));
            this.body = this.input.read(n);
        }
    }

    private void parseChunks() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.readChunkSize();
        while (n != 0) {
            stringBuffer.append(this.input.read(n));
            this.readCRLF();
            n = this.readChunkSize();
        }
        this.body = stringBuffer.toString();
    }

    private int readChunkSize() throws Exception {
        String string = this.input.readLine();
        return Integer.parseInt(string, 16);
    }

    private void readCRLF() throws Exception {
        this.input.read(2);
    }

    public int getStatus() {
        return this.status;
    }

    public String getBody() {
        return this.body;
    }

    public String getHeader(String string) {
        return (String)this.headers.get(string);
    }

    public boolean hasHeader(String string) {
        return this.headers.containsKey(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Status: ").append(this.status).append("\n");
        stringBuffer.append("Headers: ").append("\n");
        for (String string : this.headers.keySet()) {
            stringBuffer.append("\t").append(string).append(": ").append(this.headers.get(string)).append("\n");
        }
        stringBuffer.append("Body: ").append("\n");
        stringBuffer.append(this.body);
        return stringBuffer.toString();
    }

    public static ResponseParser performHttpRequest(String string, int n, RequestBuilder requestBuilder) throws Exception {
        Socket socket = new Socket(string, n);
        OutputStream outputStream = socket.getOutputStream();
        InputStream inputStream = socket.getInputStream();
        requestBuilder.send(outputStream);
        outputStream.flush();
        ResponseParser responseParser = new ResponseParser(inputStream);
        socket.close();
        return responseParser;
    }
}

