/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.ResponseSender;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.TimeZone;

public abstract class Response {
    public static final String DEFAULT_CONTENT_TYPE = "text/html; charset=utf-8";
    protected static final String CRLF = "\r\n";
    private int status = 200;
    private HashMap headers = new HashMap(17);
    private String contentType = "text/html; charset=utf-8";

    public static SimpleDateFormat makeStandardHttpDateFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat;
    }

    public Response() {
    }

    public Response(int n) {
        this.status = n;
    }

    public abstract void readyToSend(ResponseSender var1) throws Exception;

    protected abstract void addSpecificHeaders();

    public abstract int getContentSize();

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public String makeHttpHeaders() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HTTP/1.1 ").append(this.status).append(" ").append(this.getReasonPhrase()).append(CRLF);
        this.makeHeaders(stringBuffer);
        stringBuffer.append(CRLF);
        return stringBuffer.toString();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public void redirect(String string) {
        this.status = 303;
        this.addHeader("Location", string);
    }

    public void setMaxAge(int n) {
        this.addHeader("Cache-Control", "max-age=" + n);
    }

    public void setLastModifiedHeader(String string) {
        this.addHeader("Last-Modified", string);
    }

    public void setExpiresHeader(String string) {
        this.addHeader("Expires", string);
    }

    public void addHeader(String string, String string2) {
        this.headers.put(string, string2);
    }

    public String getHeader(String string) {
        return (String)this.headers.get(string);
    }

    public byte[] getEncodedBytes(String string) throws Exception {
        return string.getBytes("UTF-8");
    }

    private void makeHeaders(StringBuffer stringBuffer) {
        for (String string : this.headers.keySet()) {
            String string2 = (String)this.headers.get(string);
            stringBuffer.append(string).append(": ").append(string2).append(CRLF);
        }
    }

    protected void addStandardHeaders() {
        this.addHeader("Content-Type", this.getContentType());
        this.addSpecificHeaders();
    }

    protected String getReasonPhrase() {
        return Response.getReasonPhrase(this.status);
    }

    public static String getReasonPhrase(int n) {
        switch (n) {
            case 100: {
                return "Continue";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Found";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Time-out";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-URI Too Large";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 416: {
                return "Requested range not satisfiable";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Time-out";
            }
            case 505: {
                return "HTTP Version not supported";
            }
        }
        return "Unknown Status";
    }
}

