/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.components.Base64;
import fitnesse.util.StreamReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class RequestBuilder {
    private static final byte[] ENDL = "\r\n".getBytes();
    private String resource;
    private String method = "GET";
    private List bodyParts = new LinkedList();
    private HashMap headers = new HashMap();
    private HashMap inputs = new HashMap();
    private String host;
    private int port;
    private String boundary;
    private boolean isMultipart = false;
    private int bodyLength = 0;

    public RequestBuilder(String string) {
        this.resource = string;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public void addHeader(String string, String string2) {
        this.headers.put(string, string2);
    }

    public String getText() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.send(byteArrayOutputStream);
        return byteArrayOutputStream.toString();
    }

    private String buildRequestLine() throws Exception {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.method).append(" ").append(this.resource);
        if (this.isGet() && (string = this.inputString()).length() > 0) {
            stringBuffer.append("?").append(string);
        }
        stringBuffer.append(" HTTP/1.1");
        return stringBuffer.toString();
    }

    private boolean isGet() {
        return this.method.equals("GET");
    }

    public void send(OutputStream outputStream) throws Exception {
        outputStream.write(this.buildRequestLine().getBytes("UTF-8"));
        outputStream.write(ENDL);
        this.buildBody();
        this.sendHeaders(outputStream);
        outputStream.write(ENDL);
        this.sendBody(outputStream);
    }

    private void sendHeaders(OutputStream outputStream) throws Exception {
        this.addHostHeader();
        for (String string : this.headers.keySet()) {
            outputStream.write((string + ": " + this.headers.get(string)).getBytes("UTF-8"));
            outputStream.write(ENDL);
        }
    }

    private void buildBody() throws Exception {
        if (!this.isMultipart) {
            byte[] byArray = this.inputString().getBytes("UTF-8");
            this.bodyParts.add(new ByteArrayInputStream(byArray));
            this.bodyLength += byArray.length;
        } else {
            for (String string : this.inputs.keySet()) {
                Object v = this.inputs.get(string);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("--").append(this.getBoundary()).append("\r\n");
                stringBuffer.append("Content-Disposition: form-data; name=\"").append(string).append("\"").append("\r\n");
                if (v instanceof InputStreamPart) {
                    InputStreamPart inputStreamPart = (InputStreamPart)v;
                    stringBuffer.append("Content-Type: ").append(inputStreamPart.contentType).append("\r\n");
                    stringBuffer.append("\r\n");
                    this.addBodyPart(stringBuffer.toString());
                    this.bodyParts.add(inputStreamPart.input);
                    this.bodyLength += inputStreamPart.size;
                    this.addBodyPart("\r\n");
                    continue;
                }
                stringBuffer.append("Content-Type: text/plain").append("\r\n");
                stringBuffer.append("\r\n");
                stringBuffer.append(v);
                stringBuffer.append("\r\n");
                this.addBodyPart(stringBuffer.toString());
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("--").append(this.getBoundary()).append("--").append("\r\n");
            this.addBodyPart(stringBuffer.toString());
        }
        this.addHeader("Content-Length", this.bodyLength + "");
    }

    private void addBodyPart(String string) throws Exception {
        byte[] byArray = string.toString().getBytes("UTF-8");
        this.bodyParts.add(new ByteArrayInputStream(byArray));
        this.bodyLength += byArray.length;
    }

    private void sendBody(OutputStream outputStream) throws Exception {
        for (InputStream inputStream : this.bodyParts) {
            StreamReader streamReader = new StreamReader(inputStream);
            while (!streamReader.isEof()) {
                byte[] byArray = streamReader.readBytes(1000);
                outputStream.write(byArray);
            }
        }
    }

    private void addHostHeader() {
        if (this.host != null) {
            this.addHeader("Host", this.host + ":" + this.port);
        } else {
            this.addHeader("Host", "");
        }
    }

    public void addInput(String string, Object object) throws Exception {
        this.inputs.put(string, object);
    }

    public String inputString() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (String string : this.inputs.keySet()) {
            String string2 = (String)this.inputs.get(string);
            if (!bl) {
                stringBuffer.append("&");
            }
            stringBuffer.append(string).append("=").append(URLEncoder.encode(string2, "UTF-8"));
            bl = false;
        }
        return stringBuffer.toString();
    }

    public void addCredentials(String string, String string2) throws Exception {
        String string3 = string + ":" + string2;
        String string4 = Base64.encode(string3);
        this.addHeader("Authorization", "Basic " + string4);
    }

    public void setHostAndPort(String string, int n) {
        this.host = string;
        this.port = n;
    }

    public String getBoundary() {
        if (this.boundary == null) {
            this.boundary = "----------" + new Random().nextInt() + "BoUnDaRy";
        }
        return this.boundary;
    }

    public void addInputAsPart(String string, Object object) throws Exception {
        this.multipart();
        this.addInput(string, object);
    }

    public void addInputAsPart(String string, InputStream inputStream, int n, String string2) throws Exception {
        this.addInputAsPart(string, new InputStreamPart(inputStream, n, string2));
    }

    private void multipart() {
        if (!this.isMultipart) {
            this.isMultipart = true;
            this.setMethod("POST");
            this.addHeader("Content-Type", "multipart/form-data; boundary=" + this.getBoundary());
        }
    }

    private static class InputStreamPart {
        public InputStream input;
        public int size;
        public String contentType;

        public InputStreamPart(InputStream inputStream, int n, String string) {
            this.input = inputStream;
            this.size = n;
            this.contentType = string;
        }
    }
}

