/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.components.Base64;
import fitnesse.http.HttpException;
import fitnesse.http.UploadedFile;
import fitnesse.util.StreamReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Request {
    private static final Pattern requestLinePattern = Pattern.compile("(\\p{Upper}+?) ([^\\s]+)");
    private static final Pattern requestUriPattern = Pattern.compile("([^?]+)\\??(.*)");
    private static final Pattern queryStringPattern = Pattern.compile("([^=]*)=?([^&]*)&?");
    private static final Pattern headerPattern = Pattern.compile("([^:]*): (.*)");
    private static final Pattern boundaryPattern = Pattern.compile("boundary=(.*)");
    private static final Pattern multipartHeaderPattern = Pattern.compile("([^ =]+)=\\\"([^\"]*)\\\"");
    private static Collection allowedMethods = Request.buildAllowedMethodList();
    protected StreamReader input;
    protected String requestURI;
    protected String resource;
    protected String queryString;
    protected HashMap inputs = new HashMap();
    protected HashMap headers = new HashMap();
    protected String entityBody = "";
    protected String requestLine;
    protected String authorizationUsername;
    protected String authorizationPassword;
    private boolean hasBeenParsed;
    private long bytesParsed = 0L;

    public static Set buildAllowedMethodList() {
        HashSet<String> hashSet = new HashSet<String>(20);
        hashSet.add("GET");
        hashSet.add("POST");
        return hashSet;
    }

    protected Request() {
    }

    public Request(InputStream inputStream) throws Exception {
        this.input = new StreamReader(new BufferedInputStream(inputStream));
    }

    public void parse() throws Exception {
        this.readAndParseRequestLine();
        this.headers = this.parseHeaders(this.input);
        this.parseEntityBody();
        this.hasBeenParsed = true;
    }

    private void readAndParseRequestLine() throws Exception {
        this.requestLine = this.input.readLine();
        Matcher matcher = requestLinePattern.matcher(this.requestLine);
        this.checkRequestLine(matcher);
        this.requestURI = matcher.group(2);
        this.parseRequestUri(this.requestURI);
    }

    private HashMap parseHeaders(StreamReader streamReader) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = streamReader.readLine();
        while (!"".equals(string)) {
            Matcher matcher = headerPattern.matcher(string);
            if (matcher.find()) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                hashMap.put(string2.toLowerCase(), string3);
            }
            string = streamReader.readLine();
        }
        return hashMap;
    }

    private void parseEntityBody() throws Exception {
        if (this.hasHeader("Content-Length")) {
            String string = (String)this.getHeader("Content-Type");
            if (string != null && string.startsWith("multipart/form-data")) {
                Matcher matcher = boundaryPattern.matcher(string);
                matcher.find();
                this.parseMultiPartContent(matcher.group(1));
            } else {
                this.entityBody = this.input.read(this.getContentLength());
                this.parseQueryString(this.entityBody);
            }
        }
    }

    public int getContentLength() {
        return Integer.parseInt((String)this.getHeader("Content-Length"));
    }

    private void parseMultiPartContent(String string) throws Exception {
        string = "--" + string;
        int n = this.getContentLength();
        this.accumulateBytesReadAndReset();
        this.input.readUpTo(string);
        while ((long)n - this.input.numberOfBytesConsumed() > 10L) {
            this.input.readLine();
            HashMap hashMap = this.parseHeaders(this.input);
            String string2 = (String)hashMap.get("content-disposition");
            Matcher matcher = multipartHeaderPattern.matcher(string2);
            while (matcher.find()) {
                hashMap.put(matcher.group(1), matcher.group(2));
            }
            String string3 = (String)hashMap.get("name");
            Object object = hashMap.containsKey("filename") ? this.createUploadedFile(hashMap, this.input, string) : this.input.readUpTo("\r\n" + string);
            this.inputs.put(string3, object);
        }
    }

    private void accumulateBytesReadAndReset() {
        this.bytesParsed += this.input.numberOfBytesConsumed();
        this.input.resetNumberOfBytesConsumed();
    }

    private Object createUploadedFile(HashMap hashMap, StreamReader streamReader, String string) throws Exception {
        String string2 = (String)hashMap.get("filename");
        String string3 = (String)hashMap.get("content-type");
        File file = File.createTempFile("FitNesse", ".uploadedFile");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        streamReader.copyBytesUpTo("\r\n" + string, bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).close();
        return new UploadedFile(string2, string3, file);
    }

    private void checkRequestLine(Matcher matcher) throws HttpException {
        if (!matcher.find()) {
            throw new HttpException("The request string is malformed and can not be parsed");
        }
        if (!allowedMethods.contains(matcher.group(1))) {
            throw new HttpException("The " + matcher.group(1) + " method is not currently supported");
        }
    }

    public void parseRequestUri(String string) {
        Matcher matcher = requestUriPattern.matcher(string);
        matcher.find();
        this.resource = this.stripLeadingSlash(matcher.group(1));
        this.queryString = matcher.group(2);
        this.parseQueryString(this.queryString);
    }

    protected void parseQueryString(String string) {
        Matcher matcher = queryStringPattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = Request.decodeContent(matcher.group(2));
            this.inputs.put(string2, string3);
        }
    }

    public String getRequestLine() {
        return this.requestLine;
    }

    public String getRequestUri() {
        return this.requestURI;
    }

    public String getResource() {
        return this.resource;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public boolean hasInput(String string) {
        return this.inputs.containsKey(string);
    }

    public Object getInput(String string) {
        return this.inputs.get(string);
    }

    public boolean hasHeader(String string) {
        return this.headers.containsKey(string.toLowerCase());
    }

    public Object getHeader(String string) {
        return this.headers.get(string.toLowerCase());
    }

    public String getBody() {
        return this.entityBody;
    }

    private String stripLeadingSlash(String string) {
        return string.substring(1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("--- Request Start ---").append("\n");
        stringBuffer.append("Request URI:  ").append(this.requestURI).append("\n");
        stringBuffer.append("Resource:     ").append(this.resource).append("\n");
        stringBuffer.append("Query String: ").append(this.queryString).append("\n");
        stringBuffer.append("Hearders: (" + this.headers.size() + ")\n");
        this.addMap(this.headers, stringBuffer);
        stringBuffer.append("Form Inputs: (" + this.inputs.size() + ")\n");
        this.addMap(this.inputs, stringBuffer);
        stringBuffer.append("Entity Body: ").append("\n");
        stringBuffer.append(this.entityBody).append("\n");
        stringBuffer.append("--- End Request ---\n");
        return stringBuffer.toString();
    }

    private void addMap(HashMap hashMap, StringBuffer stringBuffer) {
        if (hashMap.size() == 0) {
            stringBuffer.append("\tempty");
        }
        for (String string : hashMap.keySet()) {
            String string2 = hashMap.get(string) != null ? this.escape(hashMap.get(string).toString()) : null;
            stringBuffer.append("\t" + this.escape(string) + " \t-->\t " + string2 + "\n");
        }
    }

    private String escape(String string) {
        return string.replaceAll("[\n\r]+", "|");
    }

    public static String decodeContent(String string) {
        String string2 = null;
        try {
            string2 = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = "URLDecoder Error";
        }
        return string2;
    }

    public boolean hasBeenParsed() {
        return this.hasBeenParsed;
    }

    public String getUserpass(String string) throws Exception {
        String string2 = string.substring(6);
        return Base64.decode(string2);
    }

    public void getCredentials() throws Exception {
        String string;
        String string2;
        String[] stringArray;
        if (this.hasHeader("Authorization") && (stringArray = (string2 = this.getUserpass(string = this.getHeader("Authorization").toString())).split(":")).length == 2) {
            this.authorizationUsername = stringArray[0];
            this.authorizationPassword = stringArray[1];
        }
    }

    public String getAuthorizationUsername() {
        return this.authorizationUsername;
    }

    public String getAuthorizationPassword() {
        return this.authorizationPassword;
    }

    public long numberOfBytesParsed() {
        return this.bytesParsed + this.input.numberOfBytesConsumed();
    }
}

