/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.testutil.MockSocket;
import java.net.Socket;

public class MockResponseSender
implements ResponseSender {
    public MockSocket socket = new MockSocket("Mock");
    public boolean closed = false;

    public MockResponseSender() {
    }

    public MockResponseSender(Response response) throws Exception {
        this();
        this.doSending(response);
    }

    public void send(byte[] byArray) throws Exception {
        this.socket.getOutputStream().write(byArray);
    }

    public void close() throws Exception {
        this.closed = true;
    }

    public Socket getSocket() throws Exception {
        return this.socket;
    }

    public String sentData() throws Exception {
        return this.socket.getOutput();
    }

    public void doSending(Response response) throws Exception {
        response.readyToSend(this);
        this.waitForClose(10000L);
    }

    public void waitForClose(long l) throws Exception {
        long l2 = System.currentTimeMillis();
        while (!this.closed) {
            Thread.yield();
            long l3 = System.currentTimeMillis();
            if (l3 - l2 <= l) continue;
            throw new Exception("MockResponseSender could not be closed");
        }
    }
}

