/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.util.StreamReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class InputStreamResponse
extends Response {
    private StreamReader reader;
    private int contentSize = 0;

    public void readyToSend(ResponseSender responseSender) throws Exception {
        this.addStandardHeaders();
        responseSender.send(this.makeHttpHeaders().getBytes());
        while (!this.reader.isEof()) {
            responseSender.send(this.reader.readBytes(1000));
        }
        this.reader.close();
        responseSender.close();
    }

    protected void addSpecificHeaders() {
        this.addHeader("Content-Length", this.getContentSize() + "");
    }

    public int getContentSize() {
        return this.contentSize;
    }

    public void setBody(InputStream inputStream, int n) {
        this.reader = new StreamReader(inputStream);
        this.contentSize = n;
    }

    public void setBody(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = (int)file.length();
        this.setBody(fileInputStream, n);
    }
}

