/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import java.nio.ByteBuffer;

public class ChunkedResponse
extends Response {
    private ResponseSender sender;
    private int bytesSent = 0;
    private boolean isReadyToSend = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readyToSend(ResponseSender responseSender) throws Exception {
        this.sender = responseSender;
        this.addStandardHeaders();
        responseSender.send(this.makeHttpHeaders().getBytes());
        this.isReadyToSend = true;
        ChunkedResponse chunkedResponse = this;
        synchronized (chunkedResponse) {
            this.notify();
        }
    }

    public boolean isReadyToSend() {
        return this.isReadyToSend;
    }

    protected void addSpecificHeaders() {
        this.addHeader("Transfer-Encoding", "chunked");
    }

    public static String asHex(int n) {
        return Integer.toHexString(n);
    }

    public void add(String string) throws Exception {
        if (string != null) {
            this.add(this.getEncodedBytes(string));
        }
    }

    public void add(byte[] byArray) throws Exception {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        String string = ChunkedResponse.asHex(byArray.length) + "\r\n";
        ByteBuffer byteBuffer = ByteBuffer.allocate(string.length() + byArray.length + 2);
        byteBuffer.put(string.getBytes()).put(byArray).put("\r\n".getBytes());
        this.sender.send(byteBuffer.array());
        this.bytesSent += byArray.length;
    }

    public void addTrailingHeader(String string, String string2) throws Exception {
        String string3 = string + ": " + string2 + "\r\n";
        this.sender.send(string3.getBytes());
    }

    public void closeChunks() throws Exception {
        this.sender.send("0\r\n".getBytes());
    }

    public void closeTrailer() throws Exception {
        this.sender.send("\r\n".getBytes());
    }

    public void close() throws Exception {
        this.sender.close();
    }

    public void closeAll() throws Exception {
        this.closeChunks();
        this.closeTrailer();
        this.close();
    }

    public int getContentSize() {
        return this.bytesSent;
    }
}

